/*!
 * jQuery Cropper v1.0.0
 * https://github.com/fengyuanchen/jquery-cropper
 *
 * Copyright (c) 2018 Chen Fengyuan
 * Released under the MIT license
 *
 * Date: 2018-04-01T06:20:13.168Z
 */

(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(require('jquery'), require('cropperjs')) :
  typeof define === 'function' && define.amd ? define(['jquery', 'cropperjs'], factory) :
  (factory(global.jQuery,global.Cropper));
}(this, (function ($,Cropper) { 'use strict';

  $ = $ && $.hasOwnProperty('default') ? $['default'] : $;
  Cropper = Cropper && Cropper.hasOwnProperty('default') ? Cropper['default'] : Cropper;

  if ($.fn) {
    var AnotherCropper = $.fn.cropper;
    var NAMESPACE = 'cropper';

    $.fn.cropper = function jQueryCropper(option) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var result = void 0;

      this.each(function (i, element) {
        var $element = $(element);
        var isDestroy = option === 'destroy';
        var cropper = $element.data(NAMESPACE);

        if (!cropper) {
          if (isDestroy) {
            return;
          }

          var options = $.extend({}, $element.data(), $.isPlainObject(option) && option);

          cropper = new Cropper(element, options);
          $element.data(NAMESPACE, cropper);
        }

        if (typeof option === 'string') {
          var fn = cropper[option];

          if ($.isFunction(fn)) {
            result = fn.apply(cropper, args);

            if (result === cropper) {
              result = undefined;
            }

            if (isDestroy) {
              $element.removeData(NAMESPACE);
            }
          }
        }
      });

      return result !== undefined ? result : this;
    };

    $.fn.cropper.Constructor = Cropper;
    $.fn.cropper.setDefaults = Cropper.setDefaults;
    $.fn.cropper.noConflict = function noConflict() {
      $.fn.cropper = AnotherCropper;
      return this;
    };
  }

})));    

var uploadedImageType = 'image/jpeg';
$('#tsuploadnow').change(function () 
    { 
      $('#cropoverlay').show();
      var files = this.files;
      var file; 
      if (files && files.length) 
      {         
        file = files[0];
        if (/^image\/\w+$/.test(file.type)) {
          uploadedImageName = file.name;
          uploadedImageType = file.type; 
          uploadedImageURL = URL.createObjectURL(file);  
          $('#image').cropper('destroy').attr('src', uploadedImageURL).cropper(options);
          $('#image').val('');
          return false;
        } else {
          window.alert('Please choose an image file.');
        }
      }
    });
    $('#cropedit').click(function()
    {
        $('#cropoverlay').show();
        $('#image').cropper(options);
    });
    
    $(document).ready(function () {    
      $('.cropbuttons .btn').click(function () {
        var $this = $(this);
        var $image =  $('#image');
        var data = $this.data();
        var cropper = $('#image').data('cropper');
        var cropped;
        var $target;
        var result;
        
        if (cropper && data.method) {
          data = $.extend({}, data);      
          if (typeof data.target !== 'undefined') {
            $target = $(data.target);    
            if (typeof data.option === 'undefined') {
              try {
                data.option = JSON.parse($target.val());
              } catch (e) {
                console.log(e.message);
              }
            }
          }    
          cropped = cropper.cropped;    
          switch (data.method) {
            case 'getCroppedCanvas':
              if (uploadedImageType === 'image/jpeg') {
                if (!data.option) {
                  data.option = {};
                }   
                data.option.fillColor = '#fff';
              }  
            break;
            case 'cancel':
                $('#cropoverlay').hide();   
            break; 
          }   
          result = $image.cropper(data.method, data.option, data.secondOption);

          switch (data.method) {
            case 'scaleX':
            case 'scaleY':
              $(this).data('option', -data.option);
            break; 
            case 'getCroppedCanvas':
              if (result) {             
                  $('#cropoverlay').hide(); 
                  console.log(picname);
                  $('#tsresult').attr('src',result.toDataURL(uploadedImageType));
                  
                  $('.loadingaction').slideToggle();
                     $.ajax({
                        type: "POST",
                        data: {"saveimage":"1","name": picname,"cid": cid,"ctype": ctype,"title": title,"directory": directory,"imagedata": result.toDataURL(uploadedImageType)},
                        url: '/admin/modules/ajax/ajaxbridge.php',
                        success: function(data) {
                            $('.loadingaction').slideToggle(function() {$('.saveokaction').slideToggle(); $('.saveokaction').delay(1200).slideToggle();});
                            readadmingallery(cid,ctype,directory);
                            $('#ptitle').html(data)
                        }
                    });
                  
                  
              }   
            break;      
          }
        }
      });
    }); 
