<?php

if (isset($classes_included['InterTicket'])) return;
$classes_included['InterTicket'] = 1;

if (file_exists("/var/www/clients/client65/web117/web/admin/modules/sync/interticket/include/config.php")) require_once "/var/www/clients/client65/web117/web/admin/modules/sync/interticket/include/config.php";

/**
 * Object for managing XML communications trough the InterTicket TiXML Interface
 * @package InterTicket
 * @author Joseph Kizman - IntertTicket
 * @copyright 2011 Joseph Kizman - IntertTicket
 */
class InterTicket {
	public $debug = 0;
	public $logging = 0;
	public $statistics = 1;
	public $logobj = false;
	public $caching = 1;
	public $cache_dir = "cache/tixml/";
	public $cachelife = 1;
	public $stagesightlife = 24;
	public $tixml_browser_id = "";
	public $tixml_common_browser_id = false;
	public $tixml_server;
	public $tixml_port;
	public $tixml_prefix;
	public $tixml_login;
	public $tixml_password;
	public $tixml_timeout = 9000;
	public $tixml_nexpacketOffset = 0;
	public $tixml_eventPacketSize = 3000;
	public $tixml_timeformat;
	public $tixml_intimeformat;
	public $tixml_time_difference;
	public $tixml_venue_type_id;
	public $tixml_venue_id = 0;
	public $tixml_program_type_id;
	public $tixml_chart_url;
	public $tixml_basket_url;
	public $tixml_venue_filter=Array();
	public $tixml_audit_filter=Array();
	public $tixml_program_filter=Array();
	public $tixml_region_id;
	public $transbind = "";
	public $tixml_last_request;
	public $tixml_last_response;
	public $tixml_last_query_error_message;
	public $tixml_last_query_is_error;
	public $tixml_extra_charge;
	public $tixml_translator_enabled = 0;
	public $tixml_translation_enabled = 0;
	public $tixml_translator_url = "";
	public $tixml_translator_lang = "";
	public $tixml_translator_visit_log_next = 0;
	public $errorHandling = 1;
	public $errorTracing = 0;
	public $last_events_data;
	private $hashsalt = "ITS2006";
	public $translatetable;
	public $paypath_list = Array(1=>"Skipjack", 2=>"Ospi", 3=>"iVeriLite", 4=>"Moneris", 5=>"SecPay", 6=>"DataTrans", 7=>"YourPay", 8=>"Telehaz",
						9=>"eProcessing", 10=>"TMobil", 11=>"Wallit", 12=>"SkipJack2", 13=>"OTPShop", 14=>"CMPS", 15=>"JCC", 16=>"PayPalDirect",
						17=>"Tatrabank Pay-Card", 18=>"OTPShop (new)", 19=>"eProcessing (new)", 20=>"SECPay (new)", 21=>"SkipJack (new)", 22=>"YourPay (new)",
						23=>"CMPS (new)", 24=>"eWay Australia", 25=>"Endeavour Malta", 26=>"OTPShop (3D)", 27=>"E-xact", 28=>"AKBank Virtual POS",
						29=>"FirstData", 30=>"LinkPoint", 31=>"MyCheckOut", 32=>"Authorize.Net", 33=>"QuickPay3D");
	public $basket_tracking_enabled = 0;
	public $basket_tracking_table = "it_basket_events";
	public $basket_tracking_sql = null;
	public $event_cache_table = "it_events_cache";
	public $programimfo_index;
	public $RCSpeedUpEnabled = false;

	// ------------- constructor start ------------//
	/**
	 * Object Constructor method
	 * If it doesn't get any of the needed parameters or gets empty string, tries to search for default values
	 * @param string $server TiXML server URL
	 * @param string $port TiXML server Port
	 * @param string $prefix TiXML instance name (ex. A_tixml)
	 * @param string $login TiXML username
	 * @param string $pass TiXML password
	 * @param string $timeformat Timeformat used in reply XML-s
	 * @param string $intimeformat Timeformat Used in queries
	 * @param string $type Venue Type ID
	 * @param string $program Program Type ID
	 * @param string $chart_url Not used anymore
	 * @param string $basket_url Not used anymore
	 */
	function InterTicket($server="", $port="", $prefix="", $login="", $pass="", $timeformat="", $intimeformat="", $type="", $program="", $chart_url="", $basket_url="", $extra_charge="") {
		if ($this->file_exists("/var/www/clients/client65/web117/web/admin/modules/sync/interticket/include/class.logger.php")) include_once "/var/www/clients/client65/web117/web/admin/modules/sync/interticket/include/class.logger.php";
	if ($this->file_exists("/var/www/clients/client65/web117/web/admin/modules/sync/interticket/include/lib.interticket.php")) {
		include_once "/var/www/clients/client65/web117/web/admin/modules/sync/interticket/include/lib.interticket.php";
	}
	 $this->tixml_server = $server=="" ? $GLOBALS['tixml_default_server'] : $server;
	 $this->tixml_port = $port=="" ? $GLOBALS['tixml_default_port'] : $port;
	 $this->tixml_prefix = $prefix=="" ? $GLOBALS['tixml_default_prefix'] : $prefix;
	 $this->tixml_login = $login=="" ? $GLOBALS['tixml_default_login'] : $login;
	 $this->tixml_password = $pass=="" ? $GLOBALS['tixml_default_password'] : $pass;
	 $this->tixml_timeformat = $timeformat=="" ? $GLOBALS['tixml_default_timeformat'] : $timeformat;
	 $this->tixml_intimeformat = $intimeformat=="" ? $GLOBALS['tixml_default_intimeformat'] : $intimeformat;
	 $this->tixml_time_difference = isset($GLOBALS['tixml_default_time_difference']) ? $GLOBALS['tixml_default_time_difference'] : 0;
	 $this->tixml_venue_type_id = $type=="" ? $GLOBALS['tixml_default_venue_type_id'] : $type;
	 $this->tixml_program_type_id = $program=="" ? $GLOBALS['tixml_default_program_type_id'] : $program;
	 $this->tixml_chart_url = $chart_url=="" ? $GLOBALS['tixml_default_chart_url'] : $chart_url;
	 $this->tixml_basket_url = $basket_url=="" ? $GLOBALS['tixml_default_basket_url'] : $basket_url;
	 $this->tixml_extra_charge = $extra_charge=="" ? $GLOBALS['tixml_region_ticket_extra_charge'] : $extra_charge;
	 $this->tixml_translator_url = isset($GLOBALS['tixml_default_translator_url']) ? $GLOBALS['tixml_default_translator_url'] : "";
	 $this->tixml_translator_enabled = $this->tixml_translator_url=="" ? 0 : 1;
	 if (isset($_SESSION['sess_region'])) $this->tixml_region_id = $_SESSION['sess_region'];

	 if (strpos($_SERVER['REQUEST_URI'], "pay")!==false) $this->errorHandling = 0;
	 if (class_exists("Logger")) $this->logobj = isset($GLOBALS['log']) ? $GLOBALS['log'] : new Logger();

	 if ($this->tixml_browser_id == "" && empty($_SESSION['browser_id']) && $_SESSION['browser_id']!=="0" ) {
		if ($this->debug == 1) echo "Getting new browser_id.<br>";
		$this->new_browser_id();
	 } else if ($this->tixml_browser_id == "" && !empty($_SESSION['browser_id']) ) {
		if ($this->debug == 1) echo "Restoring browser_id from session.<br>";
		$this->tixml_browser_id = $_SESSION['browser_id'];
	 }

	 if ($this->tixml_browser_id==$_SESSION["browser_id_common_".$_SESSION['sess_region']]) $this->tixml_common_browser_id = true;

	 //var_dump($this->tixml_common_browser_id);

	 if (isset($GLOBALS['sql'])) $this->basket_tracking_sql = $GLOBALS['sql'];
	}
	// ------------- constructor end ------------//

	// ------------- logging start ----------------//
	/**
	 * Logging function, internallay used for logging errors
	 * Needs a 'Logger' object given in the 'logobj' parameter of the object
	 * @param string $type Logfile Name
	 * @param string $tolog Log Content
	 * @param string $customdir Target directory (Default: "log/")
	 * @access private
	 */
	function log($type, $tolog, $customdir="", $functname="") {
	 if ($this->logobj == false) $this->logobj = isset($GLOBALS['log']) ? $GLOBALS['log'] : new Logger();
	 $this->logobj->log($type, $functname."\n".$tolog, $customdir);
	}
	// ------------- logging end -----------------//

	// ------------- Staring out -----------------//
	/**
	 * Helper function for 'preg_callback' to replace credit card characters with stars, only leaving the last 4 letters in tact
	 * @param string $preg_array Array given by 'preg_callback' with the matches
	 * @param string $showlength Number of characters to show on the end of the string
	 * @access private
	 */
	function starout ($preg_array, $showlength=4) {
	 $stars = "";
	 if (is_array($preg_array)) {
		for ($i=0;$i<(strlen($preg_array[1]));$i++) $stars .= "*";
		if ($preg_array[1]!==$stars) {
		 $result = preg_replace('['.$preg_array[1].''.$preg_array[2].']', $stars.$preg_array[2], $preg_array[0]);
		} else {
		 $result = $preg_array[0];
		}
		return $result;
	 } else {
		for ($i=0;$i<(strlen($preg_array)-$showlength);$i++) $stars .= "*";
		return $stars.substr($preg_array, strlen($preg_array)-$showlength);
	 }
	}
	// ------------- Staring out end -------------//

	// ------------- date convert ----------------//
	/**
	 * Generates Unix time from a string
	 * String pattern formula is very similar to PHP's date functions's
	 * Y: Year
	 * m: Month with numerals
	 * d: Days with numerals
	 * H: Hours with numerals in 24H format
	 * h: Hours with numerals in 12H format
	 * i: Minutes with numerals
	 * s: Seconds with numerals
	 * A: AM/PM marker for 12H formats
	 * %l: Weekday in text format
	 * %D: Weekday in short text format
	 * %F: Month in text format
	 * %M: Month in short text format
	 * @param string $value Input string to parse
	 * @param string $frompattern Pattern of the input string
	 */
	function date_totime ($value, $frompattern) {
	 $keyfields = array ("Y"=>4, "m"=>2, "d"=>2, "H"=>2, "h"=>2, "i"=>2, "s"=>2, "A"=>2);
	 $endpos = strlen($frompattern);
	 for ($i=0;$i<$endpos;$i++) {
		$actfield = substr($frompattern, $i, 1);
		if (isset($keyfields[$actfield])) {
		 $foundvalue = trim(substr($value, $i, $keyfields[$actfield]), ':/. ');
		 $atime[$actfield] = $foundvalue;
		 $frompattern = str_replace($actfield, $foundvalue, $frompattern);
		 if (strlen($foundvalue)==1 && $keyfields[$actfield]==2) $foundvalue = "0".$foundvalue;
		 $topattern = str_replace($actfield, $foundvalue, $topattern);
		 $i += count($atime[$actfield]);
		 $endpos += $keyfields[$actfield];
		}
	 }
	 if (!isset($atime['H']) && isset($atime['h'])) {
		$atime['H'] = $atime['h'];
		$atime['H'] += ($atime['A']=="PM" && $atime['h']!=="12") ? 12 : 0;
		$atime['H'] -= ($atime['A']=="AM" && $atime['h']=="12") ? 12 : 0;
		if (strlen($atime['H'])==1) $atime['H'] = "0".$atime['H'];
	 } else if (!isset($atime['h']) && $atime['H']) {
		$atime['h'] = $atime['h'];
		$atime['h'] += $atime['H']>12 ? $atime['H']-12 : $atime['H'];
		$atime['A'] = $atime['H']>=12 ? "PM" : "AM";
		if (strlen($atime['h'])==1) $atime['h'] = "0".$atime['h'];
		$topattern = str_replace("h", $atime['h'], $topattern);
		$topattern = str_replace("A", $atime['A'], $topattern);
	 }
	 if (!isset($atime['s'])) $atime['s'] = 0;
	 //print_r($atime);
	 $timestamp = mktime($atime['H'], $atime['i'], $atime['s'], $atime['m'], $atime['d'], $atime['Y']);
	 return $timestamp;
	}
	/**
	 * Generates time string from an other time string
	 * String pattern formula is very similar to PHP's date functions's
	 * Y: Year
	 * m: Month with numerals
	 * d: Days with numerals
	 * H: Hours with numerals in 24H format
	 * h: Hours with numerals in 12H format
	 * i: Minutes with numerals
	 * s: Seconds with numerals
	 * A: AM/PM marker for 12H formats
	 * %l: Weekday in text format
	 * %D: Weekday in short text format
	 * %F: Month in text format
	 * %M: Month in short text format
	 * @param string $value Input string to parse
	 * @param string $frompattern Pattern of the input string
	 * @param string $topattern Pattern of the output string
	 */
	function convert_date ($value, $frompattern="", $topattern="") {
	 $keyfields = array ("Y"=>4, "m"=>2, "d"=>2, "H"=>2, "h"=>2, "i"=>2, "s"=>2, "A"=>2);
	 $endpos = strlen($frompattern);
	 for ($i=0;$i<$endpos;$i++) {
		$actfield = substr($frompattern, $i, 1);
		if (isset($keyfields[$actfield])) {
		 $foundvalue = trim(substr($value, $i, $keyfields[$actfield]), ':/. ');
		 $atime[$actfield] = $foundvalue;
		 $frompattern = str_replace($actfield, $foundvalue, $frompattern);
		 if (strlen($foundvalue)==1 && $keyfields[$actfield]==2) $foundvalue = "0".$foundvalue;
		 $topattern = str_replace($actfield, $foundvalue, $topattern);
		 $i += count($atime[$actfield]);
		 $endpos += $keyfields[$actfield];
		}
	 }
	 if (!isset($atime['H']) && isset($atime['h'])) {
		$atime['H'] = $atime['h'];
		$atime['H'] += ($atime['A']=="PM" && $atime['h']!=="12") ? 12 : 0;
		$atime['H'] -= ($atime['A']=="AM" && $atime['h']=="12") ? 12 : 0;
		if (strlen($atime['H'])==1) $atime['H'] = "0".$atime['H'];
		$topattern = str_replace("H", $atime['H'], $topattern);
	 } else if (!isset($atime['h']) && isset($atime['H'])) {
		//$atime['h'] = $atime['h'];
		$atime['h'] = $atime['H']>12 ? $atime['H']-12 : $atime['H'];
		$atime['A'] = $atime['H']>=12 ? "PM" : "AM";
		if (strlen($atime['h'])==1) $atime['h'] = "0".$atime['h'];
		$topattern = str_replace("h", $atime['h'], $topattern);
		$topattern = str_replace("A", $atime['A'], $topattern);
	 }
	 $timestamp = mktime($atime['H'], $atime['i'], $atime['s'], $atime['m'], $atime['d'], $atime['Y']);
	 $adate = getdate($timestamp);
	 if (strpos($topattern, "%l") !== false) {
		$weekday = $GLOBALS['language_weekdays'][$adate['wday']];
		$topattern = str_replace("%l", $weekday, $topattern);
	 }
	 if (strpos($topattern, "%D") !== false) {
		$weekday = $GLOBALS['language_weekdays_short'][$adate['wday']];
		$topattern = str_replace("%D", $weekday, $topattern);
	 }
	 if (strpos($topattern, "%F") !== false) {
		$month = $GLOBALS['language_months'][$adate['mon']];
		$topattern = str_replace("%F", $month, $topattern);
	 }
	 if (strpos($topattern, "%M") !== false) {
		$month = $GLOBALS['language_months_short'][$adate['mon']];
		$topattern = str_replace("%M", $month, $topattern);
	 }
	 return $topattern;
	}
	/**
	 * Generates time string from a Unix time
	 * String pattern formula is very similar to PHP's date functions's
	 * Y: Year
	 * m: Month with numerals
	 * d: Days with numerals
	 * H: Hours with numerals in 24H format
	 * h: Hours with numerals in 12H format
	 * i: Minutes with numerals
	 * s: Seconds with numerals
	 * A: AM/PM marker for 12H formats
	 * %l: Weekday in text format
	 * %D: Weekday in short text format
	 * %F: Month in text format
	 * %M: Month in short text format
	 * @param string $value Input Unix time to parse
	 * @param string $topattern Pattern of the output string
	 */
	function get_date ($value, $topattern) {
	 $keyfields = array ("Y"=>4, "m"=>2, "d"=>2, "H"=>2, "h"=>2, "i"=>2, "s"=>2, "A"=>2);
	 foreach ($keyfields as $key => $length) {
		$topattern = str_replace($key, date($key, $value), $topattern);
	 }
	 $adate = getdate($value);
	 $weekday = $GLOBALS['language_weekdays'][$adate['wday']];
	 $topattern = str_replace("%l", $weekday, $topattern);
	 $weekday = $GLOBALS['language_weekdays_short'][$adate['wday']];
	 $topattern = str_replace("%D", $weekday, $topattern);
	 $month = $GLOBALS['language_months'][$adate['mon']];
	 $topattern = str_replace("%F", $month, $topattern);
	 $month = $GLOBALS['language_months_short'][$adate['mon']];
	 $topattern = str_replace("%M", $month, $topattern);
	 return $topattern;
	}
	// ------------- date convert end  -----------//

	// ------------- Connection ----------------- //
	/**
	 * Makes a tixml request
	 * If Object paramater "connection_module" is set to "curl", it forwards the data to the curl method function 'tixml_connect_curl' otherwise uses the fsockopen method
	 * <br>This function Should only be used by the functions of this object
	 * @param string $xml_in Input XML to post
	 * @param string $nolog Logging disabling function
	 * @return String
	 */
	function tixml_connect ($xml_in, $nolog=false) {
	 $this->tixml_last_request = $xml_in;
	 $this->tixml_last_response = "";
		 ob_start();
	 var_dump(debug_backtrace(false));
	 if (isset($_GET['traceme'])) $backtrace = ob_get_contents();
	 ob_end_clean();
	 if (($this->logging == 1 && $nolog==false) || (isset($_GET['logme']) && $_GET['logme']==1)) $this->log("tixml_".$this->tixml_browser_id, $xml_in, "tixml/".date("Y")."_".date("m")."_".date("d")."/");
	 if (extension_loaded("curl")) {
		$xml_out = $this->tixml_connect_curl($xml_in);
	 } else {
		$xml_out = $this->glob_tixml_connect($xml_in);
	 }
	 if (($this->logging == 1 && $nolog==false) || (isset($_GET['logme']) && $_GET['logme']==1)) $this->log("tixml_".$this->tixml_browser_id, $this->tixml_server."\r\n".$xml_out."\r\n".$backtrace, "tixml/".date("Y")."_".date("m")."_".date("d")."/");
	 $this->tixml_last_query_is_error = $this->checkerrors($xml_in, $xml_out);
	 $this->tixml_last_response = $xml_out;
	 return $xml_out;
	}
	/**
	 * Makes a tixml request trough the 'tixml_connect' function
	 * <br>This function Should only be used by the functions of this object
	 * @param string $xml_in Input XML to post
	 * @param string $level XML parsing level that depends on the expected reply XML
	 * @return Array
	 */
	function tixml_connect_array ($xml_in, $level=3) {
	 if ($this->logging == 1) $this->log("tixml", $xml_in, "tixml/".date("Y")."_".date("m")."_".date("d")."/");
	 $xml_out = $this->tixml_connect($xml_in);
	 $result = $this->glob_tixml_to_array($xml_out, $level);
	 if ($this->logging == 1) $this->log("tixml", $xml_out, "tixml/".date("Y")."_".date("m")."_".date("d")."/");
	 return $result;
	}
	/**
	 * Makes a tixml request with curl
	 * <br>This function Should only be used by the functions of this object
	 * @param string $xml_in Input XML to post
	 * @return String
	 * @access private
	 */
	function tixml_connect_curl($xml_in) {
	 $mt = microtime(true);
	 $xml_data = rawurlencode($xml_in);
	 $ifsecure = $this->tixml_port==443 ? "s" : "";
   //$siteid = $_SERVER['SERVER_NAME'];
	 $siteid = "dev.koncert.hu";
	 $logmod = "";
	 if ($this->tixml_translator_visit_log_next == 1) {
		$this->tixml_translator_visit_log_next = 0;
		$logmod = "&logreq=1";
	 }

	 $result = "";
	 $i = 0;
	 $rc = 0;
	 while ($rc!=200 && $i<5) {
			if ($i>0) sleep(1);
			$ch = curl_init("http".$ifsecure."://".$this->tixml_server."/".$this->tixml_prefix);
			//echo "http".$ifsecure."://".$this->tixml_server."/".$this->tixml_prefix;
			curl_setopt($ch, CURLOPT_PORT, $this->tixml_port);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, true);
			curl_setopt($ch, CURLOPT_VERBOSE, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, "xmlrequest=".$xml_data."&siteid=".$siteid.$logmod);
			curl_setopt($ch, CURLOPT_TIMEOUT, $this->tixml_timeout);
		$result = curl_exec($ch);
		$rc = strpos($result, "?xml")!==false ? curl_getinfo($ch, CURLINFO_HTTP_CODE) : 500;
			if ($rc==200) curl_close($ch);
			if (isset($_GET['logme']) && $rc==500 ) echo $i."-".$this->tixml_server."-".$rc."-".strlen($result)." - ".$result."<br> ";
		$i++;
	 }
	 //if ($rc==200 && strlen($result)<1000 && isset($_GET['logme'])) echo $result;
	if ($rc!=200) $result = false;
	if (strpos($result, "Internal Server Error")!=false) $result = false;
		 $closerpos = strrpos($xml_in, '</');
		 $closerendpos = strpos($xml_in, ">", $closerpos);
		 $funcname = trim(substr($xml_in, $closerpos+2, $closerendpos-$closerpos-1), "<>");
	 if (isset($_GET['dbg'])) echo $funcname;
	 if ($result!==FALSE) {
		// performance logging
		if ($this->statistics == 1 && function_exists("restoreconfig") ) {
		 $mt2 = microtime(true);
		 $mtd = ($mt2-$mt);
		 $mtd = round($mtd, 6);
	 if (isset($_GET['dbg'])) echo " - ".$mtd."<br>";
		 $configfilename = $this->configfilepath("perf", $this->tixml_region_id);
		 if (!file_exists($configfilename.".tmp")) {
			$perf_conf = restoreconfig("perf", $this->tixml_region_id);
			copy($configfilename, $configfilename.".tmp");
			if (!isset($perf_conf[$funcname])) {
			 $perf_conf[$funcname]['MAX'] = 0;
			 $perf_conf[$funcname]['MIN'] = 0;
			 $perf_conf[$funcname]['AVERAGE'] = 0;
			 $perf_conf[$funcname]['COUNT'] = 0;
			}
			$perf_conf[$funcname]['MIN'] = ($perf_conf[$funcname]['MIN']>$mtd || $perf_conf[$funcname]['MIN']==0) ? $mtd : $perf_conf[$funcname]['MIN'];
			$perf_conf[$funcname]['MAX'] = $perf_conf[$funcname]['MAX']<$mtd ? $mtd : $perf_conf[$funcname]['MAX'];
			$perf_conf[$funcname]['AVERAGE'] = (($perf_conf[$funcname]['AVERAGE']*$perf_conf[$funcname]['COUNT'])+$mtd)/($perf_conf[$funcname]['COUNT']+1);
			$perf_conf[$funcname]['AVERAGE'] = round($perf_conf[$funcname]['AVERAGE'], 6);
			$perf_conf[$funcname]['COUNT']++;
			saveconfig("perf", $this->tixml_region_id, $perf_conf);
			unlink($configfilename.".tmp");
		 }
		}
		curl_close($ch);
		return $result;
	 } else {
		// error logging
		//$connerr = $host.":".$port." - ".gethostbyname ($host)." - ".$errno." - ".$errstr."\n";
		$connerr = $this->tixml_server."/".$this->tixml_prefix.":".$this->tixml_port." - ".gethostbyname ($this->tixml_server)." - ".curl_error($ch);
		$this->log("tixml_error", $connerr, "", $funcname);
		curl_close($ch);
		return false;
	 }
	}

	/**
	 * Makes a tixml request with fsockopen
	 * <br>This function Should only be used by the functions of this object
	 * @param string $xml_in Input XML to post
	 * @return String
	 * @access private
	 */
	function glob_tixml_connect($xml_in)
	{
	 $mt = microtime(true);
	 $xml_data = rawurlencode($xml_in);
	 $result = '';

	 $fp = fsockopen ($this->tixml_server,$this->tixml_port,$errno,$errstr,$this->tixml_timeout);
	 if ($fp) {
		fputs ($fp,"
POST /".$this->tixml_prefix."?xmlrequest=".$xml_data."
Host: ".$this->tixml_server."
Content-Length: 7
Content-Type: application/x-www-form-urlencoded
Connection: Close
");
		while (!feof($fp)) {
		 $result = $result . fgets ($fp,128);
		}
		fclose ($fp);
		// performance logging
		if ($this->statistics == 1 && function_exists("restoreconfig")) {
		$mt2 = microtime(true);
		$mtd = ($mt2-$mt);
		$mtd = round($mtd, 6);
		$closerpos = strrpos($xml_in, "</");
		$closerendpos = strpos($xml_in, ">", $closerpos);
		$funcname = trim(substr($xml_in, $closerpos+2, $closerendpos-$closerpos-1), "<>");
		$configfilename = $this->configfilepath("perf", $this->tixml_region_id);
		if (!file_exists($configfilename.".tmp")) {
		 $perf_conf = restoreconfig("perf", $this->tixml_region_id);
		 copy($configfilename, $configfilename.".tmp");
		 if (!isset($perf_conf[$funcname])) {
			$perf_conf[$funcname]['MAX'] = 0;
			$perf_conf[$funcname]['MIN'] = 0;
			$perf_conf[$funcname]['AVERAGE'] = 0;
			$perf_conf[$funcname]['COUNT'] = 0;
		 }
		 $perf_conf[$funcname]['MIN'] = ($perf_conf[$funcname]['MIN']>$mtd || $perf_conf[$funcname]['MIN']==0) ? $mtd : $perf_conf[$funcname]['MIN'];
		 $perf_conf[$funcname]['MAX'] = $perf_conf[$funcname]['MAX']<$mtd ? $mtd : $perf_conf[$funcname]['MAX'];
		 $perf_conf[$funcname]['AVERAGE'] = (($perf_conf[$funcname]['AVERAGE']*$perf_conf[$funcname]['COUNT'])+$mtd)/($perf_conf[$funcname]['COUNT']+1);
		 $perf_conf[$funcname]['AVERAGE'] = round($perf_conf[$funcname]['AVERAGE'], 6);
		 $perf_conf[$funcname]['COUNT']++;
		 saveconfig("perf", $this->tixml_region_id, $perf_conf);
		 unlink($configfilename.".tmp");
		 }
		}
		return $result;
	 } else {
		// error logging
		$connerr = $host.":".$port." - ".gethostbyname ($host)." - ".$errno." - ".$errstr."\n";
		$this->log("tixml_error", $connerr);
		return false;
	 }
	}
	/**
	 * Makes a cached request
	 * <br>If the cache file modification time is below the time limit, it will return that value
	 * @param string $xml_in Input XML
	 * @param string $cachefile Cache file name
	 * @param int $cachelife Time limit of the cache lifetime, if not given, the dafaul object value is used
	 * @return String
	 */
	function tixml_cached_connect ($xml_in, $cachefile, $cachelife=false) {
	 $subdir = $this->tixml_region_id."/" ;
	 if (!file_exists($this->cache_dir)) mkdir ($this->cache_dir, 0777, true);
	 $cachefile = $this->cache_dir.$subdir.$cachefile;
	 $cachelife = !$cachelife ? $this->cachelife*3600 : $cachelife;
	 if (isset($_GET['nocache']) || $this->caching==0 || !file_exists($cachefile) || (filesize($cachefile)==0 &&  filemtime($cachefile)<time()-30 ) || (file_exists($cachefile) && filemtime($cachefile)<time()-($cachelife))) {
		$xml_out = $this->tixml_connect($xml_in);
		if ($this->caching!==0 && strpos($xml_out, "<errormsg>")===FALSE && !is_null($xml_out) && !empty($xml_out) ) {
		 if (!file_exists($this->cache_dir)) mkdir($this->cache_dir, 0777, true);
		 if (!file_exists($this->cache_dir.$subdir)) mkdir($this->cache_dir.$subdir, 0777, true);
		 if ($xml_out!=="") {
			file_put_contents($cachefile, $xml_out);
	 }
	}
	return $xml_out;
	 } else {
		return file_get_contents($cachefile);
	 }
	}

	/**
	 * Checks for error messages in TiXml response, and logs them if any found
	 * <br>This function Should only be used by the functions of this object
	 * @param string $xml_in Input XML
	 * @param string $xml_out Output XML
	 * @return Bool
	 * @access private
	 */
	function checkerrors ($xml_in, $xml_out) {
	 $result = false;
	 $this->tixml_last_query_error_message = "";
	 if (strpos($this->tixml_last_request, "</AuditGetStagePicture>")===FALSE && strpos($this->tixml_last_request, "</PutItemToBasket>")===FALSE
			&& (strpos(strtolower($xml_out), "errormessage")!==false || strpos(strtolower($xml_out), "errormsg")!==false)
	 ) {
		$resultdata = $this->glob_tixml_to_array($xml_out, 3);
		if (isset($resultdata['ERRORMESSAGE']) && $resultdata['ERRORMESSAGE'][0] !== "") {
	 $conndata = $this->tixml_server."/".$this->tixml_prefix.":".$this->tixml_port;
	 ob_start();
	 var_dump(debug_backtrace(false));
	 $backtrace = ob_get_contents();
	 ob_end_clean();
		 if ($this->errorTracing==1) $this->log("tixml_error", $conndata."\r\n".$xml_in."\r\n\r\n".$xml_out."\n\n".$backtrace);
		 else $this->log("tixml_error", $conndata."\r\n".$xml_in."\r\n\r\n".$xml_out);
		 $result = true;
		}
		$resultdata = $this->glob_tixml_to_array($xml_out, 2);
		if (isset($resultdata['ERRORMSG']) && $resultdata['ERRORMSG'][0] !== "") {
		 $this->tixml_last_query_error_message = $resultdata['ERRORMSG'][0];
		 if ($this->errorHandling==1 && !isset($_GET['finishtransaction']) ) {
			if (strpos(strtolower($resultdata['ERRORMSG'][0]), "cannot find browser_id")!==false) $this->new_browser_id();
			if (strpos(strtolower($resultdata['ERRORMSG'][0]), "invalid browser id")!==false) $this->new_browser_id();
		 }
	 $conndata = $this->tixml_server."/".$this->tixml_prefix.":".$this->tixml_port;
	 ob_start();
	 var_dump(debug_backtrace(false));
	 $backtrace = ob_get_contents();
	 ob_end_clean();
		 if ($this->errorTracing==1) $this->log("tixml_error", $conndata."\r\n".$xml_in."\r\n\r\n".$xml_out."\n\n".$backtrace);
		 else $this->log("tixml_error", $conndata."\r\n".$xml_in."\r\n\r\n".$xml_out);
		 $result = true;
		}
	 }
	 $this->tixml_last_query_is_error = $result;
	 return $result;
	}
	/**
	 * Creates a basic array from the XML text on the specified level
	 * <br>This function Should only be used by the functions of this object
	 * @param string $xml_out Output XML
	 * @param int $level Target XML Level
	 * @return Array
	 * @access private
	 */
	function glob_tixml_to_array ($xml_out, $level=3) {
	//echo $xml_out;
	//----------------------------------array create
	$mt1 = microtime(true);
	$parser = xml_parser_create();
	xml_parse_into_struct($parser,$xml_out,$ertek,$index);
	xml_parser_free($parser);
	$closerpos = strrpos($xml_out, "</");
		$closerendpos = strpos($xml_out, ">", $closerpos);
		$funcname = trim(substr($xml_out, $closerpos+2, $closerendpos-$closerpos-1), "<>");
	if (isset($_GET['dbg'])) echo "XML parse ".$funcname." (".$level.") - ".(microtime(true)-$mt1)."<br>";
	 //if (xml_get_error_code($parser)!=0) echo xml_error_string(xml_get_error_code($parser));
	 //----------------------------------array create end
	 //print_r($ertek);
	 $result = Array();
	 foreach ($ertek as $fielditem) {
		if ($fielditem['level']==$level && $fielditem['type']=="complete") $result[$fielditem['tag']][] = isset($fielditem['value']) ? $fielditem['value'] : "";
	 }
	 return $result;
	}
	function SXML_get_array ($xml_out, $converttocapital=false) {
	if (!function_exists("simplexml_load_string")) return false;
	libxml_use_internal_errors(true);
	$sxml = simplexml_load_string($xml_out);
	/*if ($sxml==false) {
					var_dump($xml_out);
		foreach (libxml_get_errors() as $error) {
					var_dump($error);
			}
		}*/
	if ($sxml!==false && method_exists($sxml, "children")) $xmla = $this->convertXmlObjToArr($sxml, $converttocapital);
	else $xmla = Array();
	$root_element_name = "";
	//if (method_exists($xmla, "getName") )
	if (is_object($sxml)) $root_element_name = $sxml->getName();
	if (!empty($root_element_name) && !$converttocapital) $xmla = Array($root_element_name=>$xmla);
	else if (!empty($root_element_name) && $converttocapital) $xmla = Array(strtoupper($root_element_name)=>$xmla);
	//var_dump(method_exists($xmla, "getName"));
	return $xmla;
	}
	function convertXmlObjToArr( $obj, $converttocapital=false) {
		$result = Array();
		foreach ($obj->children() as $ename=>$element) {
			$NodeName = empty($ename) ? $element->getName() : $ename;
			if ($converttocapital) $NodeName = strtoupper($NodeName);
			if (count($element->children())>0) {
			if (is_array($result) && array_key_exists($NodeName, $result) && !array_key_exists(0, $result[$NodeName]) ) {
				$result[$NodeName] = Array(0=>$result[$NodeName]);
			}
			if (array_key_exists($NodeName, $result) && array_key_exists(0, $result[$NodeName]) && is_array($result[$NodeName]) ) {
				$result[$NodeName][] = $this->convertXmlObjToArr($element, $converttocapital);
			} else {
				$result[$NodeName] = $this->convertXmlObjToArr($element, $converttocapital);
			}
		} else if (!empty($NodeName)) {
			$result[$NodeName] = trim((string)$element);
		}
	}
		return $result;
	}
	function convertkeytouppercase($arr) {
		$result = Array();
		foreach ($arr as $k=>$v) {
			if (is_array($v)) $result[strtoupper($k)] = $this->convertkeytouppercase($v);
			else $result[strtoupper($k)] = $v;
		}
		return $result;
	}

	function getXmlArray ($xmldata, $encoding="UTF-8") {
	 $xmlp = xml_parser_create($encoding);
	 xml_parse_into_struct($xmlp, $xmldata, $vals, $index);
	 xml_parser_free($xmlp);
	 $output = $this->parseXmlArray($vals);
	 return $output;
	}

function parseXmlArray($tagitems) {
 $output = Array();
 $i=0;
 while ($i<count($tagitems)) {
	if ($tagitems[$i]['type']=="open") {
	 $closerfound = $i;
	 for ($j=$i+1;$j<=count($tagitems);$j++) {
		if ($closerfound==$i &&
				$tagitems[$j]['type']=="close" &&
				$tagitems[$j]['tag']==$tagitems[$i]['tag'] &&
				$tagitems[$j]['level']==$tagitems[$i]['level'] ) $closerfound = $j;
	 }
	 $newtagitems = Array();
	 for ($j=$i+1;$j<$closerfound;$j++) {
		$newtagitems[] = $tagitems[$j];
	 }
	 $subarray = $this->parseXmlArray($newtagitems);
	 if (isset($output[$tagitems[$i]['tag']][0])) {
		$output[$tagitems[$i]['tag']][] = $subarray;
	 } else if (is_array($output) && isset($output[$tagitems[$i]['tag']]) ) {
		$temp = $output[$tagitems[$i]['tag']];
		unset($output[$tagitems[$i]['tag']]);
		$output[$tagitems[$i]['tag']] = Array();
		$output[$tagitems[$i]['tag']][] = $temp;
		$output[$tagitems[$i]['tag']][] = $subarray;
	 } else if (trim($subarray)!=="") {
		$output[$tagitems[$i]['tag']] = $subarray;
	 }
	 if (isset($tagitems[$i]['attributes'])) {
		foreach ($tagitems[$i]['attributes'] as $attrname=>$currattr) {
		 $output[$tagitems[$i]['tag']][$attrname] = $currattr;
		}
	 }
	 $i = $closerfound;
	} else if ($tagitems[$i]['type']=="complete") {
	 $output[$tagitems[$i]['tag']] = is_string($tagitems[$i]['value']) ? trim($tagitems[$i]['value']) : $tagitems[$i]['value'];
	}
	$i++;
 }
 return $output;
}

	/**
	 * Checks a filter if the given value is filtered or not
	 * <br>Returns true if it is passed, false if not
	 * @param Array $filter The filter array to check
	 * @param string $value The value to check the filter against
	 * @return Boolean
	 */
	function checkfilter ($filter, $value) {
	 if (count($filter)>0 && isset($filter['MODE']) && isset($filter['ITEMS']) && count($filter['ITEMS'])>0 &&
							(
								(intval($filter['MODE'])==1 && !in_array($value, $filter['ITEMS'])) ||
								(intval($filter['MODE'])==0 && in_array($value, $filter['ITEMS']))
							)
			) {
			 return true;
			} else if (count($filter)==0 || count($filter['ITEMS'])==0) {
			 return true;
			} else {
			 return false;
			}
	}
	// ------------- Connection end ------------- //

	// --- interticket_browser_id --------------- //
	/**
	 * Requests a new browser_id from the system
	 * <br>Uses the get_browser_id function and Optionally saves the new value to session
	 * @param Boolean $savetosession Sets if the new value is to saved to the session. Default is True
	 * @return Boolean
	 */
	function new_browser_id ($savetosession=true) {
	 $this->tixml_browser_id = $this->get_browser_id();
	 if ($savetosession) $_SESSION['browser_id'] = $this->tixml_browser_id;
	 $this->tixml_common_browser_id=false;
	 return $this->tixml_browser_id;
	}
	/**
	 * Requests a new browser_id from the system
	 * <br>Returns the new browser_id
	 * @return String
	 */
	function get_browser_id() {
		//if (isset($GLOBALS['RC']) && $this->RCSpeedUpEnabled ) {
	//		$result = $GLOBALS['RC']->Login(strtoupper($this->tixml_login), strtoupper($this->tixml_password));
		//}
	 $xml_in  = "<?xml version='1.0' encoding='UTF-8'?>
<Login version='1'>
	<Request>
		<UserName>".strtoupper($this->tixml_login)."</UserName>
		<Password>".strtoupper($this->tixml_password)."</Password>
	</Request>
</Login>";
	 $xml_out = $this -> tixml_connect ($xml_in, true);
	 //return $xml_out;
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,3);
	 if ($this->logging == 1) $this->log("tixml_".$out_rows_data['BROWSERID']['0'], $xml_in, "tixml/".date("Y")."_".date("m")."_".date("d")."/");
	 if ($this->logging == 1) $this->log("tixml_".$out_rows_data['BROWSERID']['0'], $xml_out, "tixml/".date("Y")."_".date("m")."_".date("d")."/");
	 $result = $out_rows_data['BROWSERID']['0'];
	 return $result;
	}
	//------interticket_browser_id-end-----------//

	//----------------------cities--------------//
	/**
	 * Get's the available Cities data
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @return Array
	 * @access private
	 */
	function get_cities() {
	 $xml_in = "<?xml version='1.0' encoding='UTF-8'?>
<SearchGetCities version='1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<CityName></CityName>
		<CountryName></CountryName>
	</Request>
</SearchGetCities>
";
	 $xml_out = $this -> tixml_cached_connect ($xml_in, "cities_cache.cac");
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 return $out_rows_data;
	}
	/**
	 * Get's the available Cities data
	 * <br>Returns the array recieved from the system
	 * @return Array
	 */
	function get_city_array () {
		$cache_id = $this->cache_dir.$this->tixml_region_id."/cities";
		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id, $this->cachelife*60*60);
		}
		if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "Cities restored with CacheManager<br>";
	} else {
		 $city_data = $this->get_cities();
		 foreach ($city_data as $fieldname => $fields) {
			foreach ($fields as $num => $value) {
			 if ($value !== NULL) {
				$result[$num][$fieldname] = $value;
			 }
			}
		 }
		 if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, $this->cachelife*60*60);
	}
	return $result;
	}
	/**
	 * Get's the available City list
	 * <br>Returns the sorted auto-indexed array of the 'CITYNAME' parameter
	 * @return Array
	 */
	function get_city_list () {
	 $city_data = $this->get_city_array();
	 //print_r($city_data);
	 $city_list = Array();
	 foreach ($city_data as $city) {
		if (!in_array($city['CITYNAME'], $city_list)) {
		 $city_list[] = $city['CITYNAME'];
		}
	 }
	 asort($city_list);
	 return $city_list;
	}
	//------------------cities---end-------------//
	//---------------active-cities--------------//
	/**
	 * Get's the available Cities data for those that have active events
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @return Array
	 * @access private
	 */
	function get_active_cities() {
	 $xml_in = "<?xml version='1.0' encoding='UTF-8'?>
<SearchGetCities version='1.1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<CityName></CityName>
		<CountryName></CountryName>
		<PacketIndex>0</PacketIndex>
		<PacketSize>1000</PacketSize>
		<FromDate>".date($this->tixml_intimeformat)."</FromDate>
	</Request>
</SearchGetCities>
";
	 $xml_out = $this -> tixml_cached_connect ($xml_in, "active_cities_cache.cac");
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 return $out_rows_data;
	}
	/**
	 * Get's the available Cities data for those that have active events
	 * <br>Returns the formatted array recieved from the system
	 * @return Array
	 */
	function get_active_city_array () {
		$cache_id = $this->cache_dir.$this->tixml_region_id."/ActiveCities";
		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id, $this->cachelife*60*60);
		}
		if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "ActiveCities restored with CacheManager<br>";
	} else {
		 $city_data = $this->get_active_cities();
		 $result = Array();
		 foreach ($city_data as $fieldname => $fields) {
			foreach ($fields as $num => $value) {
			 if ($value !== NULL && $value !== "") {
				$result[$num][$fieldname] = $value;
			 }
			}
		 }
		 if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, $this->cachelife*60*60);
	}
	return $result;
	}
	/**
	 * Get's the available City list of those that have active events
	 * <br>Returns the sorted auto-indexed array of the 'CITYNAME' parameter
	 * @return Array
	 */
	function get_active_city_list () {
	 $city_data = $this->get_active_city_array();
	 //print_r($city_data);
	 $city_list = Array();
	 foreach ($city_data as $city) {
		if (!in_array(trim($city['CITYNAME']), $city_list)) {
		 $city_list[] = trim($city['CITYNAME']);
		}
	 }
	 asort($city_list);
	 return $city_list;
	}
	//----------active-cities---end-------------//
	//----------------------venues--------------//
	/**
	 * Retrieves the venues data
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $venueid Venue_id number to filter the result
	 * @param String $varos City name to filter the result
	 * @param String $nev Venue name to filter the result
	 * @return Array
	 * @access private
	 */
	function get_venues($venueid="0", $varos="", $nev="") {
	if (!empty($this->tixml_venue_id)) $venueid = $this->tixml_venue_id;
	 $xml_in = "<?xml version='1.0' encoding='UTF-8'?>
<SearchGetVenues version='1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<Venue_Id>".$venueid."</Venue_Id>
		<CityName>".$varos."</CityName>
		<VenueName>".$nev."</VenueName>
	</Request>
</SearchGetVenues>
";
	 if ($venueid=="0" && $varos=="" && $nev=="") {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "venues_cache.cac");
	 } else if ($venueid!=="0" && $varos=="" && $nev=="") {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "venues_cache_id-".$venueid.".cac");
	 } else if ($venueid=="0" && $varos!=="" && $nev=="") {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "venues_cache_city-".$varos.".cac");
	 } else {
		$xml_out = $this -> tixml_connect ($xml_in);
	 }
	 //glob_ticket_xml_to_array($result,$out_count_cols,$out_count_rows,$out_fieldbyname,$out_rows_data,$xml_out,4);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out, 4);
	 return $out_rows_data;
	}
	/**
	 * Retrieves the venues data array
	 * <br>Returns the formatted array recieved from the system
	 * @param Int $venueid Venue_id number to filter the result
	 * @param String $varos City name to filter the result
	 * @param String $nev Venue name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_venue_array ($venueid="0", $varos="", $nev="", $filter=true) {
	$filter = $venueid===false ? $venueid : $filter;
	$venueid = $venueid===false ? "0" : $venueid;
	$cache_id = $this->cache_dir.$this->tixml_region_id."/venues_".$venueid."_".md5($varos)."_".md5($nev)."_".$filter;
		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id, $this->cachelife*60*60);
		}
		if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "Venues restored with CacheManager<br>";
	} else {
		 $venue_data = $this->get_venues($venueid, $varos, $nev);
		 $result = Array();
		 //print_r($this->tixml_venue_filter);
		 foreach ($venue_data as $fieldname => $fields) {
			foreach ($fields as $num => $value) {
			 if ($value !== NULL && ($filter===false || $this->checkfilter($this->tixml_venue_filter, $venue_data['VENUENAME'][$num])))
			 {
				$result[$num][$fieldname] = $value;
			 }
			}
		 }
		 if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, $this->cachelife*60*60);
	}
	return $result;
	}
	/**
	 * Retrieves the venues list
	 * <br>Returns a sorted list of venues
	 * @param Int $venueid Venue_id number to filter the result
	 * @param String $varos City name to filter the result
	 * @param String $nev Venue name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_venue_list ($venueid="0", $varos="", $nev="", $filter=true) {
	 $filter = $venueid===false ? $venueid : $filter;
	 $venueid = $venueid===false ? "0" : $venueid;
	 $venue_data = $this->get_venue_array($venueid, $varos, $nev, $filter);
	 $venue_list = Array();
	 foreach ($venue_data as $venue) {
		if (!in_array($venue['VENUENAME'], $venue_list)) {
		 $venue_list[] = $venue['VENUENAME'];
		}
	 }
	 asort($venue_list);
	 return $venue_list;
	}
	//------------------venues---end-------------//
	//----------------------venues--------------//
	/**
	 * Retrieves the venues list of those which have active events
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $venueid Venue_id number to filter the result
	 * @param String $varos City name to filter the result
	 * @param String $nev Venue name to filter the result
	 * @return Array
	 * @access private
	 */
	function get_active_venues($venueid="0", $varos="", $nev="") {
	if (!empty($this->tixml_venue_id)) $venueid = $this->tixml_venue_id;
	 $xml_in = "<?xml version='1.0' encoding='UTF-8'?>
<SearchGetVenues version='1.2'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<Venue_Id>".$venueid."</Venue_Id>
		<CityName>".$varos."</CityName>
		<VenueName>".$nev."</VenueName>
		<FromDate>".date($this->tixml_intimeformat)."</FromDate>
		<PacketIndex>0</PacketIndex>
		<PacketSize>1000</PacketSize>
	</Request>
</SearchGetVenues>
";
	 if ($this->caching && $venueid=="0" && $varos=="" && $nev=="") {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "active_venues_cache.cac");
	 } else if ($this->caching && $venueid!=="0" && $varos=="" && $nev=="") {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "active_venues_cache_id-".$venueid.".cac");
	 } else if ($this->caching && $venueid=="0" && $varos!=="" && $nev=="") {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "active_venues_cache_city-".$varos.".cac");
	 } else {
		$xml_out = $this -> tixml_connect ($xml_in);
	 }
	 //glob_ticket_xml_to_array($result,$out_count_cols,$out_count_rows,$out_fieldbyname,$out_rows_data,$xml_out,4);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out, 4);
	 return $out_rows_data;
	}
		/**
	 * Retrieves the venues list of those which have active events
	 * <br>Returns the formatted array recieved from the system
	 * @param Int $venueid Venue_id number to filter the result
	 * @param String $varos City name to filter the result
	 * @param String $nev Venue name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_active_venue_array ($venueid="0", $varos="", $nev="", $filter=true) {
	$filter = $venueid===false ? $venueid : $filter;
	$venueid = $venueid===false ? "0" : $venueid;
	$cache_id = $this->cache_dir.$this->tixml_region_id."/activevenues_".$venueid."_".md5($varos)."_".md5($nev)."_".$filter;
	if ( isset($GLOBALS['CM']) ) {
		$result = $GLOBALS['CM']->get($cache_id, $this->cachelife*60*60);
	}
	if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "ActiveVenues restored with CacheManager<br>";
	} else {
		 $venue_data = $this->get_active_venues($venueid, $varos, $nev);
		 $result = Array();
		 //print_r($this->tixml_venue_filter);
		 foreach ($venue_data as $fieldname => $fields) {
			foreach ($fields as $num => $value) {
			 if ($value !== NULL && ($filter===false || $this->checkfilter($this->tixml_venue_filter, $venue_data['VENUENAME'][$num])))
			 {
				$result[$num][$fieldname] = $value;
			 }
			}
		 }
		if ($this->tixml_translator_enabled==1) {
			$customvenues = $this->pb_get_custom_venues_array();
			$customvenues = $customvenues['GETCUSTOMVENUESRESPONSE']['RESPONSE'];
			if (is_array($customvenues)) $customvenues = $customvenues['VENUES'];
			foreach ($customvenues as $actvenue) {
				if ($value !== NULL && ($filter===false || $this->checkfilter($this->tixml_venue_filter, $actvenue['VENUENAME'])))
				{
					$result[] = $actvenue;
				}
			}
		}
		if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, $this->cachelife*60*60);
	}
	 return $result;
	}
	/**
	 * Retrieves the venues list of those which have active events
	 * <br>Returns a sorted list of venues
	 * @param Int $venueid Venue_id number to filter the result
	 * @param String $varos City name to filter the result
	 * @param String $nev Venue name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_active_venue_list ($venueid="0", $varos="", $nev="", $filter=true) {
	 $filter = $venueid===false ? $venueid : $filter;
	 $venueid = $venueid===false ? "0" : $venueid;
	 $venue_data = $this->get_active_venue_array($venueid, $varos, $nev, $filter);
	 $venue_list = Array();
	 foreach ($venue_data as $venue) {
		if (!in_array($venue['VENUENAME'], $venue_list)) {
		 $venue_list[] = $venue['VENUENAME'];
		}
	 }
	 asort($venue_list);
	 return $venue_list;
	}
	//------------------venues---end-------------//

	//------------------audits-------------------//
	/**
	 * Retrieves the Audits data
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $auditid Audit ID number to filter the result
	 * @param String $auditname Audit name to filter the result
	 * @param String $venueid Venue ID number to filter the result
	 * @param String $venuename Venue name to filter the result
	 * @return Array
	 * @access private
	 */
	function get_audits($auditid="0", $auditname="", $venueid="0", $venuename="") {
	 if (is_array($auditid)) {
		$auditname = $auditid['AUDITNAME'];
		$venueid = $auditid['VENUE_ID'];
		$venuename = $auditid['VENUENAME'];
		$auditid = $auditid['NETAUDIT_ID'];
	 }
	 $xml_in = "<?xml version='1.0' encoding='UTF-8'?>
<SearchGetAudits version='1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<Venue_Id>".$venueid."</Venue_Id>
		<VenueType_Id>0</VenueType_Id>
		<VenueName>".$venuename."</VenueName>
		<NetAudit_Id>".$auditid."</NetAudit_Id>
		<AuditName>".$auditname."</AuditName>
	</Request>
</SearchGetAudits>
";
	 $xml_out = $this -> tixml_connect ($xml_in);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 return $out_rows_data;
	}
	/**
	 * Retrieves the Audits data
	 * <br>Returns the formatted array recieved from the system.
	 * @param Int $auditid Audit ID number to filter the result
	 * @param String $auditname Audit name to filter the result
	 * @param String $venueid Venue ID number to filter the result
	 * @param String $venuename Venue name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_audit_array ($auditid="0", $auditname="", $venueid="0", $venuename="", $filter=true) {
	$filter = $auditid===false ? $auditid : $filter;
	$auditid = $auditid===false ? "0" : $auditid;
	$cache_id = $this->cache_dir.$this->tixml_region_id."/audits_".$auditid."_".md5($auditname)."_".$venueid."_".md5($venuename)."_".$filter;
		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id, $this->cachelife*60*60);
		}
		if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "Audits restored with CacheManager<br>";
	} else {
		 $audit_data = $this->get_audits($auditid, $auditname, $venueid, $venuename);
		 $result = Array();
		 foreach ($audit_data as $fieldname => $fields) {
			foreach ($fields as $num => $value)
			{
			 if ($value !== NULL && ($filter===false || $this->checkfilter($this->tixml_audit_filter, $audit_data['AUDITNAME'][$num])))
			 {
				$result[$num][$fieldname] = $value;
			 }
			}
		 }
		 if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, $this->cachelife*60*60);
	}
	return $result;
	}
	/**
	 * Retrieves the Audits list
	 * <br>Returns the sorted list of city names recieved from the system in an array.
	 * @param Int $auditid Audit ID number to filter the result
	 * @param String $auditname Audit name to filter the result
	 * @param String $venueid Venue ID number to filter the result
	 * @param String $venuename Venue name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_audit_list ($auditid="0", $auditname="", $venueid="0", $venuename="", $filter=true) {
	 $filter = $auditid===false ? $auditid : $filter;
	 $auditid = $auditid===false ? "0" : $auditid;
	 $audit_data = $this->get_audit_array($auditid, $auditname, $venueid, $venuename, $filter);
	 $audit_list = Array();
	 foreach ($audit_data as $audit) {
		if (!in_array($audit['AUDITNAME'], $audit_list)) {
		 $audit_list[] = $audit['AUDITNAME'];
		}
	 }
	 asort($audit_list);
	 return $audit_list;
	}
	//------------------audits---end-------------//
	//------------------programs-start-----------//
	/**
	 * Retrieves the Programs data
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $programid Program ID number to filter the result
	 * @param Int $venueid Venue ID number to filter the result
	 * @param Int $auditid Audit ID number to filter the result
	 * @param String $nev Program name to filter the result
	 * @return Array
	 * @access private
	 */
	function get_programs($programid="0", $venueid="0", $auditid="0", $nev="") {
	if (!empty($this->tixml_venue_id)) $venueid = $this->tixml_venue_id;
		$xml_in  = "<?xml version='1.0' encoding='UTF-8'?>
<SearchGetPrograms version='1.0'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetProgram_Id>".$programid."</NetProgram_Id>
		<Venue_Id>".$venueid."</Venue_Id>
		<ProgramType_Id>".$this -> tixml_program_type_id."</ProgramType_Id>
		<NetAudit_Id>".$auditid."</NetAudit_Id>
		<ProgramName>".$nev."</ProgramName>
		<VenueType_Id>".$this -> tixml_venue_type_id."</VenueType_Id>
		<IfUseFavorites>false</IfUseFavorites>
	</Request>
</SearchGetPrograms>";
	 $xml_out = $this -> tixml_connect ($xml_in);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 return $out_rows_data;
	}
	/**
	 * Retrieves the Programs data
	 * <br>Returns the Program data recieved from the system in an array.
	 * @param Int $programid Program ID number to filter the result
	 * @param Int $venueid Venue ID number to filter the result
	 * @param Int $auditid Audit ID number to filter the result
	 * @param String $nev Program name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_program_array ($programid="0", $venueid="0", $auditid="0", $nev="", $filter=true) {
	$filter = $programid===false ? $programid : $filter;
	$programid = $programid===false ? "0" : $programid;
	$cache_id = $this->cache_dir.$this->tixml_region_id."/programs_".$programid."_".$venueid."_".$auditid."_".md5($nev)."_".$filter;
	if ( isset($GLOBALS['CM']) ) {
		$final = $GLOBALS['CM']->get($cache_id, 30*60);
	}
	if (!empty($final)) {
		if (isset($_GET['dbg'])) echo "Programlist restored with CacheManager<br>";
	} else {
		$event_data = $this->get_programs($programid, $venueid, $auditid, $nev, $filter);

		foreach ($event_data as $fieldname => $fields) {
			 foreach ($fields as $num => $value) {
				if ($value !== NULL && ($filter===false || $this->checkfilter($this->tixml_program_filter, $event_data['NETPROGRAM_ID'][$num]) )) {
				 $result[$num][$fieldname] = $value;
				}
			 }
		}
				if ($this->tixml_translator_enabled==1 && $this->tixml_translation_enabled==1 && $this->translatetable==null) $this->translatetable = $this->get_program_translations();
		foreach ($result as $eventdata) {
			 if ($this->tixml_translator_enabled==1 && $this->tixml_translation_enabled==1) {
					if (isset($this->translatetable[$eventdata['NETPROGRAM_ID']."_".strtoupper($this->tixml_translator_lang)])) {
						$acttrans = $this->translatetable[$eventdata['NETPROGRAM_ID']."_".strtoupper($this->tixml_translator_lang)];
							$eventdata['PROGRAMNAME_ORIGINAL'] = $eventdata['PROGRAMNAME'];
							$eventdata['VENUENAME_ORIGINAL'] = $eventdata['VENUENAME'];
							$eventdata['AUDITNAME_ORIGINAL'] = $eventdata['AUDITNAME'];
							$eventdata['PROGRAMNAME'] = $acttrans['PROGRAMNAME'];
							$eventdata['VENUENAME'] = $acttrans['VENUENAME'];
							$eventdata['AUDITNAME'] = $acttrans['AUDITNAME'];

					}
			 }
			 $final[$eventdata['NETPROGRAM_ID']] = $eventdata;
		}
		if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $final, 30*60);
	}
	 return $final;
	}
	/**
	 * Retrieves the Programs list
	 * <br>Returns the sorted list of Program names recieved from the system in an array.
	 * @param Int $programid Program ID number to filter the result
	 * @param Int $venueid Venue ID number to filter the result
	 * @param Int $auditid Audit ID number to filter the result
	 * @param String $nev Program name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_program_list ($programid="0", $venueid="0", $auditid="0", $nev="", $filter=true) {
	 $filter = $programid===false ? $programid : $filter;
	 $programid = $programid===false ? "0" : $programid;
	 $event_data = $this->get_program_array($programid, $venueid, $auditid, $nev, $filter);
	 $event_list = Array();
	 foreach ($event_data as $event) {
		if (!in_array($event['PROGRAMNAME'], $event_list)) {
		 $event_list[$event['NETPROGRAM_ID']] = $event['PROGRAMNAME'];
		}
	 }
	 asort($event_list);
	 return $event_list;
	}
	//------------------programs---end-----------//
	//-----------active-programs-start-----------//
	/**
	 * Retrieves the Programs data for those which have active events
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $programid Program ID number to filter the result
	 * @param Int $venueid Venue ID number to filter the result
	 * @param Int $auditid Audit ID number to filter the result
	 * @param String $nev Program name to filter the result
	 * @return Array
	 * @access private
	 */
	function get_active_programs($programid="0", $venueid="0", $auditid="0", $nev="", $offset=0, $fromdate="0") {
	if (!empty($this->tixml_venue_id)) $venueid = $this->tixml_venue_id;
	 $fromdate = $fromdate=="0" ? time() : $fromdate;
	 if (strpos($offset, "|")!==FALSE) {
		$size = substr($offset, strpos($offset, "|"));
		$offset = substr($offset, 0, strpos($offset, "|"));
	 } else {
		$size = 2000;
	 }
	 $xml_in  = "<?xml version='1.0' encoding='UTF-8'?>
<SearchGetPrograms version='1.2'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetProgram_Id>".$programid."</NetProgram_Id>
		<Venue_Id>".$venueid."</Venue_Id>
		<ProgramType_Id>".$this -> tixml_program_type_id."</ProgramType_Id>
		<NetAudit_Id>".$auditid."</NetAudit_Id>
		<ProgramName>".$nev."</ProgramName>
		<VenueType_Id>".$this -> tixml_venue_type_id."</VenueType_Id>
		<IfUseFavorites>false</IfUseFavorites>
		<FromDate>".date($this->tixml_intimeformat, $fromdate)."</FromDate>
		<PacketIndex>".$offset."</PacketIndex>
		<PacketSize>".$size."</PacketSize>
	</Request>
</SearchGetPrograms>";
	 if ($programid=="0" && $venueid=="0" && $auditid=="0" && $nev=="" && $offset==0) {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "active_programs_cache.cac");
	 } else {
		$xml_out = $this -> tixml_connect ($xml_in);
	 }
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 return $out_rows_data;
	}
	/**
	 * Retrieves the Programs data for those which have active events
	 * <br>Returns the Program data recieved from the system in an array.
	 * @param Int $programid Program ID number to filter the result
	 * @param Int $venueid Venue ID number to filter the result
	 * @param Int $auditid Audit ID number to filter the result
	 * @param String $nev Program name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_active_program_array ($programid="0", $venueid="0", $auditid="0", $nev="", $offset=0, $filter=true, $fromdate="0") {
	if (isset($_GET['dbg']) && $_GET['dbg']>1) echo "SearchGetPrograms requested (".$programid."/".$nev.")<br>";
	$filter = $programid===false ? $programid : $filter;
	$programid = $programid===false ? "0" : $programid;
	$cache_id = $this->cache_dir.$this->tixml_region_id."/activeprograms_".$programid."_".$venueid."_".$auditid."_".md5($nev)."_".$offset."_".$filter."_".$fromdate;
	if ( isset($GLOBALS['CM']) ) {
		$final = $GLOBALS['CM']->get($cache_id, 30*60);
	}
	if (!empty($final)) {
		if (isset($_GET['dbg'])) echo "ActiveProgramlist restored with CacheManager<br>";
	} else {
		if (isset($_GET['dbg']) && $_GET['dbg']>1) echo "ActiveProgramlist loading from system<br>";
		$event_data = $this->get_active_programs($programid, $venueid, $auditid, $nev, $offset, $fromdate);

		 foreach ($event_data as $fieldname => $fields) {
			foreach ($fields as $num => $value) {
			 if ($value !== NULL && ($filter===false || $this->checkfilter($this->tixml_program_filter, $event_data['NETPROGRAM_ID'][$num]) )) {
				$result[$num][$fieldname] = $value;
			 }
			}
		 }
		//if ($this->translatetable==null && $this->tixml_translation_enabled) $this->translatetable = $this->get_program_translations();
		//if (empty($this->programimfo_index) && isset($_GET['dbg'])) echo "loading programinfo index<br>";
		if (empty($this->programimfo_index)) $this->programimfo_index = $this->pb_get_program_info_array(true);
		 foreach ($result as $eventdata) {
			if (isset($this->programimfo_index['GETPROGRAMINFOSRESPONSE']['PROGRAM'][$eventdata['NETPROGRAM_ID']])) {
				$eventdata['PBINFO'] = $this->programimfo_index['GETPROGRAMINFOSRESPONSE']['PROGRAM'][$eventdata['NETPROGRAM_ID']];
				if (empty($eventdata['PICTURELINK'])) $eventdata['PICTURELINK'] = $this->programimfo_index['GETPROGRAMINFOSRESPONSE']['PROGRAM'][$eventdata['NETPROGRAM_ID']]['IMAGE'];
			}
			if (!empty($this->translatetable) && $this->tixml_translator_enabled==1 && $this->tixml_translation_enabled==1) {
					if (isset($this->translatetable[$eventdata['NETPROGRAM_ID']."_".strtoupper($this->tixml_translator_lang)])) {
						$acttrans = $this->translatetable[$eventdata['NETPROGRAM_ID']."_".strtoupper($this->tixml_translator_lang)];
						$eventdata['PROGRAMNAME_ORIGINAL'] = $eventdata['PROGRAMNAME'];
						$eventdata['VENUENAME_ORIGINAL'] = $eventdata['VENUENAME'];
						$eventdata['AUDITNAME_ORIGINAL'] = $eventdata['AUDITNAME'];
						$eventdata['PROGRAMNAME'] = $acttrans['PROGRAMNAME'];
						$eventdata['VENUENAME'] = $acttrans['VENUENAME'];
						$eventdata['AUDITNAME'] = $acttrans['AUDITNAME'];
					}
			}
			$final[$eventdata['NETPROGRAM_ID']] = $eventdata;
		 }
		 if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $final, 30*60);
	 }
	 if (isset($_GET['dbg']) && $_GET['dbg']>1) echo "ActiveProgramlist loaded<br>";
	 return $final;
	}
	/**
	 * Retrieves the Programs list for those which have active events
	 * <br>Returns the sorted list of Program names recieved from the system in an array of the programs.
	 * @param Int $programid Program ID number to filter the result
	 * @param Int $venueid Venue ID number to filter the result
	 * @param Int $auditid Audit ID number to filter the result
	 * @param String $nev Program name to filter the result
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_active_program_list ($programid="0", $venueid="0", $auditid="0", $nev="", $offset=0, $filter=true, $fromdate="0") {
	 $filter = $programid===false ? $programid : $filter;
	 $programid = $programid===false ? "0" : $programid;
	 $event_data = $this->get_active_program_array($programid, $venueid, $auditid, $nev, $offset, $filter, $fromdate);
	 $event_list = Array();
	 foreach ($event_data as $event) {
		if (!in_array($event['PROGRAMNAME'], $event_list)) {
		 $event_list[$event['NETPROGRAM_ID']] = $event['PROGRAMNAME'];
		}
	 }
	 asort($event_list);
	 return $event_list;
	}
	//-----------active-programs---end-----------//

	//------------------events---start-----------//
	/**
	 * Retrieves the events data
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $mikortol Starting time for the events list to start from
	 * @param Int $mennyit Number of days from Starting time to list the events
	 * @param String $nev Event Name to filter the results with
	 * @param Int $programid Program ID to filter the results with
	 * @param String $varos City Name to filter the results with
	 * @param Int $eventid Event ID to filter the results with
	 * @param String $hely Venue Name to filter the results with
	 * @param String $offset Result Offset as "PageNumber" or "PageSize|PageNumber"
	 * @return Array
	 * @access private
	 */
	function get_events ($mikortol="", $mennyit="", $nev="", $programid="0", $varos="", $eventid="0", $hely="", $offset="0", $type=0, $nulldated=false, $ticketavail=false) {
		if (empty($programid)) $programid = "0";
		if (empty($eventid)) $eventid = "0";
		if (strpos($offset, "|")!==FALSE) {
		 $size = substr($offset, strpos($offset, "|")+1);
		 $offset = substr($offset, 0, strpos($offset, "|"));
		} else {
		 $size = $this->tixml_eventPacketSize;
		}
		if (strpos($type, "|")!==FALSE) {
		 $maintype = substr($type, 0, strpos($type, "|"));
		 if ($maintype=="") $this->getprogramtype($type, 0);
		 $subtype = substr($type, strpos($type, "|")+1);
		} else {
		 $maintype = $this->getprogramtype($type, 0);
		 $subtype = $type;
		}
		$programid = $programid=="" ? "0" : $programid;
		$eventid = $eventid=="" ? "0" : $eventid;
		$currenttime = time()+$this->tixml_time_difference*60*60;
		$mikortol_time = empty($mikortol) ? time() : $mikortol;
		$kezd_date = date($this->tixml_intimeformat, $mikortol_time);
		$meddig_time = empty($mennyit) ? time()+730*24*60*60 : $mikortol_time+$mennyit*24*60*60;
		$veg_date = date($this->tixml_intimeformat, $meddig_time);
		$ticketavail = $ticketavail==true ? "true" : "false";
		//$type = intval($type)==0 ? $this->tixml_program_type_id : $type;
		$nulldated = $nulldated ? "true" : "false";
		$xml_in  = "<?xml version='1.0' encoding='UTF-8'?>
<SearchGetEvents version='1.3'";
		if ($this->tixml_translator_enabled==1) $xml_in .= " translang='".$this->tixml_translator_lang."'";
		$xml_in .= ">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetEvent_id>".$eventid."</NetEvent_id>
		<Venue_Id>".$this->tixml_venue_id."</Venue_Id>
		<TicketAvail>".$ticketavail."</TicketAvail>
		<ProgramType_id>0</ProgramType_id>
		<VenueType_Id>".$this->tixml_venue_type_id."</VenueType_Id>
		<NetProgram_id>".$programid."</NetProgram_id>
		<NetAudit_Id>0</NetAudit_Id>
		<VenueName>".$this->CDATAifneeded($hely)."</VenueName>
		<CityName>".$varos."</CityName>
		<FromDate>".$kezd_date."</FromDate>
		<ToDate>".$veg_date."</ToDate>
		<ProgramName>".$this->CDATAifneeded($nev)."</ProgramName>
		<IfNetAvailable>false</IfNetAvailable>
		<PacketIndex>".$offset."</PacketIndex>
		<PacketSize>".$size."</PacketSize>
		<NetProgramType_id>".$maintype."</NetProgramType_id>
		<NetProgramSubType_id>".$subtype."</NetProgramSubType_id>
		<LastChanged>0</LastChanged>
		<IncludeNullDatedEvents>".$nulldated."</IncludeNullDatedEvents>
	</Request>
</SearchGetEvents>";
	$st = microtime(true);
	if (empty($nev) && empty($eventid) && empty($programid) && empty($hely) && empty($varos) && empty($mikortol) && empty($mennyit) && empty($maintype) && empty($type)) {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "events_firstpage_".$ticketavail."_".$nulldated."_".$this->tixml_venue_id."_".$offset."_".$size , 10);
	} else if (empty($nev) && empty($eventid) && empty($hely) && empty($varos) && empty($mikortol) && empty($mennyit) && empty($maintype) && empty($type)) {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "events_P".$programid."_".$ticketavail."_".$nulldated."_".$this->tixml_venue_id."_".$offset."_".$size, 10);
	} else if (empty($nev) && empty($programid) && empty($hely) && empty($varos) && empty($mikortol) && empty($mennyit) && empty($maintype) && empty($type)) {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "events_E".$eventid."_".$ticketavail."_".$nulldated."_".$this->tixml_venue_id."_".$offset."_".$size, 10);
	} else if (empty($nev) && empty($programid) && empty($eventid) && empty($varos) && empty($mikortol) && empty($mennyit) && empty($maintype) && empty($type)) {
		$xml_out = $this -> tixml_cached_connect ($xml_in, "events_V".md5($hely)."_".$ticketavail."_".$nulldated."_".$this->tixml_venue_id."_".$offset."_".$size, 10);
	} else {
		$xml_out = $this -> tixml_connect ($xml_in);
	}
		$et = microtime(true);
		$out_rows_data = $this->glob_tixml_to_array($xml_out,3);
		$this->last_events_data = $out_rows_data;
	return $xml_out;
	}
	/**
	 * Retrieves the events data
	 * <br>Returns the Event data recieved from the system in a formatted array.
	 * @param Int $mikortol Starting time for the events list to start from
	 * @param Int $mennyit Number of days from Starting time to list the events
	 * @param String $nev Event Name to filter the results with
	 * @param Int $programid Program ID to filter the results with
	 * @param String $varos City Name to filter the results with
	 * @param Int $eventid Event ID to filter the results with
	 * @param String $hely Venue Name to filter the results with
	 * @param String $offset Result Offset as "PageNumber" or "PageSize|PageNumber"
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_event_array ($mikortol="", $mennyit="", $nev="", $programid="0", $varos="", $eventid="0", $hely="", $offset="0", $type=0, $nulldated=false, $filter=true, $ticketavail=false) {
	//set filter toggle if first param is false
	$filter = $mikortol===false ? $mikortol : $filter;
	$mikortol = $mikortol===false ? "" : $mikortol;
	//add special venue prefilter if needed
	if (isset($this->tixml_venue_filter['ITEMS']) && $this->tixml_venue_filter['MODE']==0 && $hely=="") {
		foreach ($this->tixml_venue_filter['ITEMS'] as $actvenue) {
			$hely .= $hely!=="" ? "," : "";
			$hely .= $actvenue;
		}
	}
	//add special program filter if needed!
	if (isset($this->tixml_program_filter['ITEMS']) && $this->tixml_program_filter['MODE']==0 && count($this->tixml_program_filter['ITEMS'])==1 && ($programid=="0" || $programid=="")) $programid = $this->tixml_program_filter['ITEMS'][0];
	// Result caching
		$cache_id = $this->cache_dir.$this->tixml_region_id."/events_".$eventid."_".$programid."_".md5($nev)."_".md5($hely)."_".md5($varos)."_".$mennyit."_".$offset."_".$type."_".$nulldated;
		$cache2_id = $this->cache_dir.$this->tixml_region_id."/eventsData_".$eventid."_".$programid."_".md5($nev)."_".md5($hely)."_".md5($varos)."_".$mennyit."_".$offset."_".$type."_".$nulldated;
		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id, 12);
			$this->last_events_data = $GLOBALS['CM']->get($cache2_id, 12);
		}

	if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "Eventlist restored with CacheManager<br>";
	} else if (strpos($this->tixml_venue_id, ",")!==false ) {
		$venues = explode(",", $this->tixml_venue_id);
		$result = Array();
		foreach ($venues as $vid) {
			$this->tixml_venue_id = $vid;
			$vdata = $this->get_events($mikortol, $mennyit, $nev, $programid, $varos, $eventid, $hely, $offset, $type, $nulldated, $ticketavail);
			$parsedList = $this->SXML_get_array($vdata);
			if (isset($parsedList['SearchGetEventsResponse']['Response']['Event']) ) $result = array_merge($result, $parsedList['SearchGetEventsResponse']['Response']['Event']);
		}
		//var_dump($result);
		$this->tixml_venue_id = implode(',', $venues);
		$result = array_subsort($result, 'EventDate');
	} else {
		if (isset($GLOBALS['RC']) && $this->RCSpeedUpEnabled ) {
			if (strpos($offset, "|")!==FALSE) {
					$size = substr($offset, strpos($offset, "|")+1);
				$offset = substr($offset, 0, strpos($offset, "|"));
			} else {
				$size = $this->tixml_eventPacketSize;
				}
		//if (false) {
			$data = $GLOBALS['RC']->get_events(Array(
			"NetProgram_Id"=>$programid,
			"Venue_id"=>$this->tixml_venue_id,
			"ProgramName"=>$nev,
			"VenueName"=>$hely,
			"NetEvent_id"=>$eventid,
			"FromDate"=>$mikortol,
			"ToDate"=>$mikortol+$mennyit*60*60*24,
			"PacketSize"=>$size,
			"PacketIndex"=>$offset,
			));
			//var_dump($data);
			//var_dump($parsedList);
			$result = $data['EventList'];
		} else {
			$event_data = $this->get_events($mikortol, $mennyit, $nev, $programid, $varos, $eventid, $hely, $offset, $type, $nulldated, $ticketavail);
			$parsedList = $this->SXML_get_array($event_data);
			$result = $parsedList['SearchGetEventsResponse']['Response']['Event'];
			//var_dump($result);
			if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache2_id, $this->last_events_data, 12);
		}
		if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, 12);
	}
	if (!isset($result[0]) && count($result)>0) $result = Array($result);

	$final = Array();
		//if ($this->tixml_translator_enabled==1 && $this->tixml_translation_enabled==1 && $this->translatetable==null) $this->translatetable = $this->get_program_translations();
		if (empty($this->programimfo_index)) $this->programimfo_index = $this->pb_get_program_info_array(true);
	foreach ($result as $eventdata) {
		foreach ($eventdata as $k=>$v) {
			unset($eventdata[$k]);
			if (is_bool($v)) $v = $v ? "true" : "false";
			$eventdata[strtoupper($k)] = $v;
		}
		if ($this->tixml_translator_enabled==1 && $this->tixml_translation_enabled==1) {
			if (isset($this->translatetable[$eventdata['NETPROGRAM_ID']."_".strtoupper($this->tixml_translator_lang)])) {
				$acttrans = $this->translatetable[$eventdata['NETPROGRAM_ID']."_".strtoupper($this->tixml_translator_lang)];
				$eventdata['PROGRAMNAME_ORIGINAL'] = $eventdata['PROGRAMNAME'];
				$eventdata['VENUENAME_ORIGINAL'] = $eventdata['VENUENAME'];
				$eventdata['AUDITNAME_ORIGINAL'] = $eventdata['AUDITNAME'];
				$eventdata['PROGRAMNAME'] = $acttrans['PROGRAMNAME'];
				$eventdata['VENUENAME'] = $acttrans['VENUENAME'];
				$eventdata['AUDITNAME'] = $acttrans['AUDITNAME'];
			}
		}
		if (empty($eventdata['PICTURELINK']) && isset($this->programimfo_index['GETPROGRAMINFOSRESPONSE']['PROGRAM'][$eventdata['NETPROGRAM_ID']])) $eventdata['PICTURELINK'] = $this->programimfo_index['GETPROGRAMINFOSRESPONSE']['PROGRAM'][$eventdata['NETPROGRAM_ID']]['IMAGE'];
		$final[$eventdata['NETEVENT_ID']] = $eventdata;
		if (
			( isset($this->tixml_program_filter['MODE']) && $this->tixml_program_filter['MODE']==1 && in_array($eventdata['NETPROGRAM_ID'], $this->tixml_program_filter['ITEMS']) )
			|| ( isset($this->tixml_program_filter['MODE']) && $this->tixml_program_filter['MODE']==0 && !in_array($eventdata['NETPROGRAM_ID'], $this->tixml_program_filter['ITEMS']) )
			|| ( isset($this->tixml_venue_filter['MODE']) && $this->tixml_venue_filter['MODE']==1 && in_array($eventdata['VENUENAME'], $this->tixml_venue_filter['ITEMS']) )
			|| ( isset($this->tixml_venue_filter['MODE']) && $this->tixml_venue_filter['MODE']==0 && !in_array($eventdata['VENUENAME'], $this->tixml_venue_filter['ITEMS']) )
			|| ( isset($this->tixml_audit_filter['MODE']) && $this->tixml_audit_filter['MODE']==1 && in_array($eventdata['NETAUDIT_ID'], $this->tixml_audit_filter['ITEMS']) )
			|| ( isset($this->tixml_audit_filter['MODE']) && $this->tixml_audit_filter['MODE']==0 && !in_array($eventdata['NETAUDIT_ID'], $this->tixml_audit_filter['ITEMS']) )
		 ) {
			unset($final[$eventdata['NETEVENT_ID']]);
		 }

	}
	if (count($final)==0) $final = "";
	if (!empty($GLOBALS['perfmon']) && method_exists($GLOBALS['perfmon'], 'displaypoint')) $GLOBALS['perfmon']->displaypoint("class.interticket : event search_end");
	return $final;
	}
	/**
	 * Retrieves the events list
	 * <br>Returns the Event list recieved from the system in an array with Program ID-s in key, and Program Names in value.
	 * @param Int $mikortol Starting time for the events list to start from
	 * @param Int $mennyit Number of days from Starting time to list the events
	 * @param String $nev Event Name to filter the results with
	 * @param Int $programid Program ID to filter the results with
	 * @param String $varos City Name to filter the results with
	 * @param Int $eventid Event ID to filter the results with
	 * @param String $hely Venue Name to filter the results with
	 * @param String $offset Result Offset as "PageNumber" or "PageSize|PageNumber"
	 * @param Boolean $filter Turns filtering off if set to false
	 * @return Array
	 */
	function get_event_list ($mikortol="", $mennyit="", $nev="", $programid="0", $varos="", $eventid="0", $hely="", $offset="0", $type=0, $nulldated=false, $filter=true, $ticketavail=true) {
	 $filter = $mikortol===false ? $mikortol : $filter;
	 $mikortol = $mikortol===false ? "" : $mikortol;
	 $event_data = $this->get_event_array($mikortol, $mennyit, $nev, $programid, $varos, $eventid, $hely, $offset, $type, $nulldated, $filter, $ticketavail);
	 $event_list = Array();
	 foreach ($event_data as $event) {
		if (!in_array($event['PROGRAMNAME'], $event_list)) {
		 $event_list[$event['NETPROGRAM_ID']] = $event['PROGRAMNAME'];
		}
	 }
	 asort($event_list);
	 return $event_list;
	}
	//------------------events---end-------------//

	//------------------pricecats---start--------//
	/**
	 * Retrieves the pricecats list data
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $event Event ID or Event Array
	 * @return Array
	 * @access private
	 */
	function get_pricecats ($event, $sectorid="0") {
	 $eventid = is_array($event) ? $event['NETEVENT_ID'] : $event;
	 $xml_in = "<?xml version='1.0' encoding='UTF-8'?>
<GetEventPriceCats version='1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetEvent_id>".$eventid."</NetEvent_id>
		<Sector_id>".$sectorid."</Sector_id>
	</Request>
</GetEventPriceCats>";
	 $xml_out = $this -> tixml_connect ($xml_in);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 return $out_rows_data;
	}
	/**
	 * Retrieves the pricecats list array
	 * <br>Returns a formatted array
	 * @param Int $event Event ID or Event Array
	 * @return Array
	 */
	function get_pricecat_array ($event, $sectorid="0") {
		$eventid = is_array($event) ? $event['NETEVENT_ID'] : $event;
		$cache_id = $this->cache_dir.$this->tixml_region_id."/PriceCats_".$eventid."_".$sectorid;
		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id, 30);
		}
		if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "PriceCats restored with CacheManager<br>";
	} else {
		$pcat_data = $this->get_pricecats($event, $sectorid);
		foreach ($pcat_data as $fieldname => $fields) {
			foreach ($fields as $num => $value) {
				$result[$num][$fieldname] = $value;
			}
		}
		if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, 30);
	}
	return $result;
	}
	/**
	 * Retrieves the pricecats list
	 * <br>Returns the list in an array with "Sector_id|SectorName" in keys and "SectorPrice" in value
	 * @param Int $event Event ID or Event Array
	 * @return Array
	 */
	function get_pricecat_list ($event, $sectorid="0") {
	 $sectorprice_data = $this->get_pricecats($eventid, $sectorid);
	 foreach ($sectorprice_data as $sectorprice) {
		if (!in_array($sectorprice['SECTOR_ID']."|".$sectorprice['SECTORNAME'], $sectorprice_list)) {
		 $sectorprice_list[$sectorprice['SECTOR_ID']."|".$sectorprice['SECTORNAME']] = $sectorprice['PRICE'];
		}
	 }
	 asort($sectorprice_list);
	 return $sectorprice_list;
	}

	/**
	 * Retrieves the list of available picecats of an event
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $event Event ID or Event Array
	 * @return Array
	 * @access private
	 */
	function get_free_pricecats ($event) {
	 $eventid = is_array($event) ? $event['NETEVENT_ID'] : $event;
	 $xml_in = "<?xml version='1.0' encoding='UTF-8'?>
<GetFreePriceCategories version='1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetEvent_id>".$eventid."</NetEvent_id>
		<User_id>0</User_id>
	</Request>
</GetFreePriceCategories>
";
	 $xml_out = $this -> tixml_connect ($xml_in);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 return $out_rows_data;
	}

	/**
	 * Retrieves the list of available picecats of an event arrayed
	 * <br>Returns a formatted array
	 * @param Int $event Event ID or Event Array
	 * @return Array
	 */
	function get_free_pricecat_array ($event) {
	 $pcat_data = $this->get_free_pricecats($event);
	 foreach ($pcat_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 return $result;
	}

	//------------------pricecats---end----------//

	//---------------sectorprices---start--------//
	/**
	 * Retrieves the sectorprices data
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $event Event ID or Event Array
	 * @param Boolean $ticketavail Restrieve results only if they have available tickets. Default=false
	 * @return Array
	 * @access private
	 */
	function get_sectorprices ($event, $ticketavail="false") {
	 $eventid = is_array($event) ? $event['NETEVENT_ID'] : $event;
	 if ($eventid>0) {
		$xml_in = "<?xml version='1.0' encoding='UTF-8'?>
<AuditGetFreeSectorsPrices version='1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetEvent_id>".$eventid."</NetEvent_id>
		<Price>0</Price>
		<TicketAvail>".$ticketavail."</TicketAvail>
	</Request>
</AuditGetFreeSectorsPrices>
";
		$xml_out = $this -> tixml_connect ($xml_in);
		$out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 }
	 return $out_rows_data;
	}
	/**
	 * Retrieves the sectorprices data
	 * <br>Returns a formatted array
	 * @param Int $event Event ID or Event Array
	 * @param Boolean $ticketavail Restrieve results only if they have available tickets. Default=false
	 * @return Array
	 */
	function get_sectorprice_array ($event, $ticketavail="false") {
	$eventid = is_array($event) ? $event['NETEVENT_ID'] : $event;
	$cache_id = $this->cache_dir.$this->tixml_region_id."/SectorPrices_".$eventid."_".$ticketavail;
		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id, 30);
		}
		if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "ActiveCities restored with CacheManager<br>";
	} else {
		$sectorprice_data = $this->get_sectorprices($event, $ticketavail);
		foreach ($sectorprice_data as $fieldname => $fields) {
			foreach ($fields as $num => $value) {
				$result[$num][$fieldname] = $value;
			}
		}
		 if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, 30);
	}
	return $result;
	}
	/**
	 * Retrieves the sectorprices list
	 * <br>Returns a list with "Sector_id|Sector_name" in key and "Price" in value
	 * @param Int $event Event ID or Event Array
	 * @param Boolean $ticketavail Restrieve results only if they have available tickets. Default=false
	 * @return Array
	 */
	function get_sectorprice_list ($event, $ticketavail="false") {
	 $sectorprice_data = $this->get_sectorprices($event, $ticketavail);
	 foreach ($sectorprice_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 $final = Array();
	 foreach ($result as $spdata) {
		$final[$spdata['SECTOR_ID']] = $spdata['SECTORNAME']."|".$spdata['PRICE'];
	 }
	 return $final;
	}

	//-----------------sectorprices---end----------//
	//--------------------Sector------------------//
	/**
	 * Retrieves the sectors data for the selected event
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $event Event ID or Event Array
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 * @access private
	 */


	function get_sectors ($event, $transtoarray=true) {
	 $eventid = is_array($event) ? $event['NETEVENT_ID'] : $event;
	 if (isset($GLOBALS['RC']) && $this->RCSpeedUpEnabled ) {
		$sectors1 = $GLOBALS['RC']->get_free_sectors($eventid, false);
		$sectors1 = $sectors1['FreeSectors'];
		$sectors2 = $GLOBALS['RC']->get_free_sectors($eventid, true);
		$sectors2 = $sectors2['FreeSectors'];
		foreach ($sectors1 as $k=>$v) {
			$ht = array_subsearch($sectors2, $v['Sector_Id'], 'Sector_Id' );
			$sectors1[$k]['freetickets'] = false;
			if ($ht!==false) {
				$sectors1[$k]['freetickets'] = true;
			}
		}
		$xmlform = "<?xml version='1.0' encoding='UTF-8'?>
<AuditGetFreeSectorsResponse><Response>";
	foreach ($sectors1 as $kk=>$vv) {
		foreach ($vv as $k=>$v) {
			unset($sectors1[$kk][$k]);
			if (is_bool($v)) $v = $v ? "true" : "false";
			if ($k!=="Version") {
				if ($k=="Sector_Id") $k="Sector_id";
				if ($transtoarray) $sectors1[$kk][strtoupper($k)] = $v;
				else $sectors1[$kk][$k] = $v;
			}
		}
		$xmlform .= "<Sector>".ArrayToXml($sectors1[$kk])."</Sector>";
	}
	$xmlform .= "</Response></AuditGetFreeSectorsResponse>";
	$out_rows_data = $transtoarray ? $sectors1 : $xmlform;
	//var_dump($out_rows_data);
	return $out_rows_data;
	 }

	 $xml_in  = "<?xml version='1.0' encoding='UTF-8'?>
<AuditGetFreeSectors version='1.1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetEvent_id>".$eventid."</NetEvent_id>
		<Price>0</Price>
		<TicketAvail>false</TicketAvail>
	</Request>
</AuditGetFreeSectors>";
	 $xml_out = $this -> tixml_connect ($xml_in);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 if (count($out_rows_data)>0) {
		foreach ($out_rows_data['SECTOR_ID'] as $outkeys => $outitems) {
		 $sidtag = "<Sector_id>".$outitems."</Sector_id>";
		 $xml_out = str_replace($sidtag, $sidtag."<freetickets>false</freetickets>", $xml_out);
		}
	 }
	 //freetickets
	 $xml_in  = "<?xml version='1.0' encoding='UTF-8'?>
<AuditGetFreeSectors version='1.1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetEvent_id>".$eventid."</NetEvent_id>
		<Price>0</Price>
		<TicketAvail>true</TicketAvail>
	</Request>
</AuditGetFreeSectors>";
	 $xml_out2 = $this -> tixml_connect ($xml_in);
	 $out_rows_data2 = $this->glob_tixml_to_array($xml_out2, 4);
	 if (isset($out_rows_data2['SECTOR_ID'])) {
		foreach ($out_rows_data2['SECTOR_ID'] as $outkeys2 => $outitems2) {
		 $sidtag = "<Sector_id>".$outitems2."</Sector_id>";
		 $xml_out = str_replace($sidtag."<freetickets>false</freetickets>", $sidtag."<freetickets>true</freetickets>", $xml_out);
		}
	 }
	 //freetickets
	 $out_rows_data = $transtoarray ? $this->glob_tixml_to_array($xml_out,4) : $xml_out;
	 return $out_rows_data;
	}
	/**
	 * Retrieves the sectors data for the selected event
	 * <br>Returns a formatted array with "SECTOR_ID" in the keys
	 * @param Int $event Event ID or Event Array
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 */
	function get_sector_array ($event) {
	 $sector_data = $this->get_sectors($event);
	 foreach ($sector_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 foreach ($result as $eventdata) {
		$final[$eventdata['SECTOR_ID']] = $eventdata;
	 }
	 return $final;
	}
	/**
	 * Retrieves the sectors data for the selected event
	 * <br>Returns a list with "Sector_id" in key and "Sectorname" in value
	 * @param Int $event Event ID or Event Array
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 */
	function get_sector_list ($event) {
	 $sector_data = $this->get_sectors($event);
	 foreach ($sector_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 foreach ($result as $sectordata) {
		$final[$sectordata['SECTOR_ID']] = $sectordata['SECTORNAME'];
	 }
	 return $final;
	}

	function get_audit_sectors ($audit_id=0, $sector_id=0, $transtoarray=false) {
	$xml_in  = "<?xml version='1.0' encoding='UTF-8'?>
	<AuditGetSectors version=\"2\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<Audit_Id>".$audit_id."</Audit_Id>
		<Sector_id>".$sector_id."</Sector_id>
		<ShowExtraSector>false</ShowExtraSector>
		<ShowCapacitySector>true</ShowCapacitySector>
		<Floor>0</Floor>
		<LeftTopX>0</LeftTopX>
		<LeftTopY>0</LeftTopY>
		<RightBottomX>20000</RightBottomX>
		<RightBottomY>20000</RightBottomY>
		<Event_id>0</Event_id>
	</Request>
	</AuditGetSectors>";
	//echo $xml_in;
	$xml_out = $this -> tixml_connect ($xml_in);
	$out_rows_data = $transtoarray ? $this->glob_tixml_to_array($xml_out,4) : $xml_out;
	return $out_rows_data;
	}
	function get_audit_sectors_array ($audit_id=0, $sector_id=0) {
	 $sector_data = $this->get_audit_sectors($audit_id, $sector_id, true);
	 //print_r($sector_data);
	 foreach ($sector_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 foreach ($result as $eventdata) {
		$final[$eventdata['SECTOR_ID']] = $eventdata;
	 }
	 return $final;
	}
 //--------------------Sector----end-----------//
 //--------------------Rows--------------------//
 /**
	 * Retrieves the rows data for the selected event
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $event Event ID or Event Array
	 * @param Int $sectorid Sector ID
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 * @access private
	 */
 function get_rows($eventid="0", $sectorid="0", $transtoarray=true) {
	$eventid = is_array($eventid) ? $eventid['NETEVENT_ID'] : $eventid;
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<AuditGetFreeRows version=\"1\">
 <Request>
	<BrowserID>".$this->tixml_browser_id."</BrowserID>
	<Sector_id>".$sectorid."</Sector_id>
	<Row_id>0</Row_id>
	<NetEvent_id>".$eventid."</NetEvent_id>
	<Price>0</Price>
	<TicketAvail>false</TicketAvail>
 </Request>
</AuditGetFreeRows>";
//echo $xml_in;
	$xml_out = $this -> tixml_connect ($xml_in);
	$out_rows_data = $transtoarray ? $this->glob_tixml_to_array($xml_out,4) : $xml_out;
	return $out_rows_data;
 }
 /**
	 * Retrieves the sectors data for the selected event
	 * <br>Returns a formatted array with "ROW_ID" in the keys
	 * @param Int $event Event ID or Event Array
	 * @param Int $sectorid Sector ID
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 */
 function get_row_array ($eventid="0", $sectorid="0") {
	 $row_data = $this->get_rows($eventid, $sectorid);
	 foreach ($row_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 foreach ($result as $rowdata) {
		$final[$rowdata['ROW_ID']] = $rowdata;
	 }
	 return $final;
 }
 /**
	 * Retrieves the rows data for the selected event
	 * <br>Returns a list with "Row_id" in key and "Rowname" in value
	 * @param Int $event Event ID or Event Array
	 * @param Int $sectorid Sector ID
	 * @return Array
	 */
	function get_row_list ($eventid="0", $sectorid="0") {
	 $row_data = $this->get_rows($eventid, $sectorid);
	 foreach ($row_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 foreach ($result as $rowdata) {
		$final[$rowdata['ROW_ID']] = $rowdata['ROWNAME'];
	 }
	 return $final;
	}
	function get_audit_rows ($venueid, $auditid, $sectorid="0") {
		$eventid = is_array($eventid) ? $eventid['NETEVENT_ID'] : $eventid;
		$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<AuditGetRows version=\"1\">
 <Request>
	<BrowserID>".$this->tixml_browser_id."</BrowserID>
	<Audit_Id>".$auditid."</Audit_Id>
	<Sector_id>".$sectorid."</Sector_id>
	<Row_Id>0</Row_Id>
	<ShowExtraSector>false</ShowExtraSector>
	<ShowCapacitySector>true</ShowCapacitySector>
	<Floor>0</Floor>
	<LeftTopX>0</LeftTopX>
	<LeftTopY>0</LeftTopY>
	<RightBottomX>20000</RightBottomX>
	<RightBottomY>20000</RightBottomY>
 </Request>
</AuditGetRows>";
//echo $xml_in;
		$xml_out = $this -> tixml_connect ($xml_in);
		return $xml_out;
	}
 //--------------------Rows------end-----------//
 //--------------------Seat--------------------//
	/**
	 * Retrieves the seats data for the selected audit
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $auditid Audit ID
	 * @param Int $sectorid Sector ID
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 * @access private
	 */
 function get_seats($auditid="0", $sectorid="0", $transtoarray=true) {
	if (empty($sectorid)) $sectorid = 0;
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<AuditGetSeats version=\"1\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetAudit_id>".$auditid."</NetAudit_id>
		<Sector_id>".$sectorid."</Sector_id>
		<LeftTopCoordX>0</LeftTopCoordX>
		<LeftTopCoordY>0</LeftTopCoordY>
		<RightBottomCoordX>0</RightBottomCoordX>
		<RightBottomCoordY>0</RightBottomCoordY>
 </Request>
</AuditGetSeats>";
	$tmpto = $this->tixml_timeout;
	$this->tixml_timeout = 30;
	$xml_out = $this -> tixml_cached_connect ($xml_in, "seats_".$auditid."_".$sectorid.".cac");
	$this->tixml_timeout = $tmpto;
	$out_rows_data = $transtoarray ? $this->glob_tixml_to_array($xml_out,4) : $xml_out;
	return $out_rows_data;
 }
 /**
	 * Retrieves the seats data for the selected audit
	 * <br>Returns a formatted array
	 * @param Int $auditid Audit ID
	 * @param Int $sectorid Sector ID
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 * @access private
	 */
 function get_seats_array($auditid="0", $sectorid="0", $transtoarray=true) {
	 $seat_data = $this->get_seats($auditid, $sectorid, $transtoarray);
	 foreach ($seat_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 foreach ($result as $seatdata) {
		$final[$seatdata['SEAT_ID']] = $seatdata;
	 }
	 return $final;
 }
 //--------------------Seat------end-----------//
 //--------------------Ticket------------------//
	/**
	 * Retrieves the tickets data for the selected audit
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $eventid Event ID
	 * @param Int $sectorid Sector ID
	 * @param String $lastchanged Date to show tickets that changed since then
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 * @access Private
	 */
 function get_tickets($eventid="0", $sectorid="0", $lastchanged="", $transtoarray=true) {
	$lastchanged = $lastchanged=="" ? "0" : $lastchanged;
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<AuditGetFreeTicketsExt version=\"1.1\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<Sector_id>".$sectorid."</Sector_id>
		<Row_id>0</Row_id>
		<NetEvent_id>".$eventid."</NetEvent_id>
		<ReqPieces>0</ReqPieces>
		<Price>0</Price>
		<TicketAvail>false</TicketAvail>
		<LeftTopCoordX>0</LeftTopCoordX>
		<LeftTopCoordY>0</LeftTopCoordY>
		<RightBottomCoordX>0</RightBottomCoordX>
		<RightBottomCoordY>0</RightBottomCoordY>
		<LastChanged>".$lastchanged."</LastChanged>
	</Request>
</AuditGetFreeTicketsExt>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$out_rows_data = $transtoarray ? $this->glob_tixml_to_array($xml_out,4) : $xml_out;
	return $out_rows_data;
 }
 /**
	 * Retrieves the tickets data for the selected audit
	 * <br>Returns a formatted array
	 * @param Int $eventid Event ID
	 * @param Int $sectorid Sector ID
	 * @param String $lastchanged Date to show tickets that changed since then
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 * @access Private
	 */
 function get_tickets_array($eventid="0", $sectorid="0", $lastchanged="", $transtoarray=true) {
	 $ticket_data = $this->get_tickets($eventid, $sectorid, $lastchanged, $transtoarray);
	 foreach ($ticket_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 foreach ($result as $ticketdata) {
		$final[$ticketdata['TICKET_ID']] = $ticketdata;
	 }
	 return $final;
 }
 //--------------------Ticket----end-----------//
 //---------------------selection--------------//
 /**
	 * Selects a ticket (modifies the status)
	 * <br>Returns the raw array recieved from the system. The usage of this function is not advised
	 * @param Int $event Event ID
	 * @param Int $seatid Seat ID OR Array of Ticket data
	 * @param Int $ticketid Ticket ID
	 * @param Int $newstatus New Status ID (2=selected, 9=free)
	 * @param Int $ticketitems Preassembled XML containing the Tixket info (Only use if you know what you are doing!)
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 * @access Private
	 */
	function select_ticket ($event, $seatid, $ticketid, $newstatus="2", $ticketitems="", $transtoarray=true) {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	 $eventid = is_array($event) ? $event['NETEVENT_ID'] : $event;
	 // 2 <- Selected
	 // 9 <- Free
	 if (is_array($seatid) && $ticketitems!=="") {
		foreach ($seatid as $key => $value ) {
		 $ticketitems .= "<Ticket><Seat_id>".$seatid[$key]['SEAT_ID']."</Seat_id><Ticket_id>".$ticketid[$key]['TICKET_ID']."</Ticket_id><Status_id>".$newstatus."</Status_id></Ticket>";
		}
	 } else if ($ticketitems=="") {
		$ticketitems .= "<Ticket><Seat_id>".$seatid."</Seat_id><Ticket_id>".$ticketid."</Ticket_id><Status_id>".$newstatus."</Status_id></Ticket>";
	 }
	 $xml_in  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<AuditSelectTickets version=\"1\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetEvent_id>".$eventid."</NetEvent_id>
		<SelectTickets>
".$ticketitems."
		</SelectTickets>
	</Request>
</AuditSelectTickets>
";
	 $xml_out = $this -> tixml_connect ($xml_in);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	 $out_rows_data = $transtoarray ? $this->glob_tixml_to_array($xml_out,4) : $xml_out;
	 return $out_rows_data;
	}
 /**
	 * Selects a ticket (modifies the status)
	 * <br>Returns a formatted array
	 * @param Int $event Event ID
	 * @param Int $seatid Seat ID OR Array of Ticket data
	 * @param Int $ticketid Ticket ID
	 * @param Int $newstatus New Status ID (2=selected, 9=free)
	 * @param Int $ticketitems Preassembled XML containing the Tixket info (Only use if you know what you are doing!)
	 * @param Boolean $transtoarray Marker if to transform the result into an array or return only the text. Default=true
	 * @return Array
	 */
	function select_ticket_array ($event, $seatid, $ticketid, $newstatus="2", $ticketitems="", $transtoarray=true) {
	 $ticket_data = $this->select_ticket($eventid, $sectorid, $lastchanged, $transtoarray);
	 foreach ($ticket_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	 return $result;
	}
 //---------------------selection-end----------//
 //----------------best selection--------------//
	function select_best_ticket($event, $sector="0", $pricecat="0", $quantity, $transtoarray=true, $getnewbid=false) {
	 if ($getnewbid) $this->new_browser_id();
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	 if (!is_array($event)) {
		$eventdata = $this->get_event_array("", "", "", "0", "", $event, "", "0", 0, false, false);
		if (count($eventdata)==0) {
		 $eventdata = $this->get_event_array("", "", "", "0", "", $event, "", "0", 0, true, false);
		}
		$event=$eventdata[$event];
	 }
	 //$event= is_array($event) ? $event : $this->get_event_array("", "", "", "0", "", $event);
	 $eventsectors = $this->get_sectorprice_array($event);
	$sectorindex = array_subsearch($eventsectors, $sector, "SECTOR_ID");
	 if (($sector=="0" || $sectorindex==false) && intval($pricecat)==0) {
		 $actsector = array_shift($eventsectors);
		 $sector = $actsector['SECTOR_ID'];
	 } else {
	$actsector = $eventsectors[$sectorindex];
	 }
	 //print_r($actsector);
	 $functiontocall = $actsector['SECTORTYPE']==1 ? "NetworkCapacitySectorSelection" : "BestTicketSelection";
	 //echo $functiontocall;
	 $xml_in  = "<?xml version='1.0' encoding='UTF-8'?>
<NewTransactionKey version='1'>
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<Venue_id>".$event['VENUE_ID']."</Venue_id>
		<Transtype>31</Transtype>
	</Request>
</NewTransactionKey>
";
	 $xml_out = $this -> tixml_connect ($xml_in);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,3);
	 $transaction_id = $out_rows_data['TRANSACTION_ID']['0'];
	 $xml_in = "<?xml version='1.0' encoding='UTF-8'?>
<".$functiontocall." version=\"1\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<Transaction_id>".$transaction_id."</Transaction_id>
		<NetEvent_id>".$event['NETEVENT_ID']."</NetEvent_id>
		<Sector_id>".$sector."</Sector_id>
		<PriceCat_id>".$pricecat."</PriceCat_id>
		<Quantity>".$quantity."</Quantity>
	</Request>
</".$functiontocall.">
";
	 $xml_out = $this -> tixml_connect ($xml_in);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,3);
	 //$result = $out_rows_data['ISSUCCESS']['0'] == "true" ? true : false;
	 $result = isset($out_rows_data['ISSUCCESS'][0]) ? strtolower($out_rows_data['ISSUCCESS'][0]) : strtolower($out_rows_data['ISSUCCES'][0]);
	 $result = $transtoarray ? $result : $xml_out;
	 return $result;
	}
 //---------------best selection-end----------//
 function get_stagepicture ($auditid="0", $seatid="0", $format="1", $transtoarray=true) {
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<AuditGetStagePicture version=\"1\">
	<Request>
	 <BrowserID>".$this->tixml_browser_id."</BrowserID>
	 <NetAudit_Id>".$auditid."</NetAudit_Id>
	 <Seat_Id>".$seatid."</Seat_Id>
	 <Format>".$format."</Format>
 </Request>
</AuditGetStagePicture>";
	$xml_out = $this -> tixml_cached_connect ($xml_in, "stagepicture_".$auditid."-".$seatid."-".$format.".cac", $this->stagesightlife);
	$out_rows_data = $transtoarray ? $this->glob_tixml_to_array($xml_out,3) : $xml_out;
	return $out_rows_data;
 }
 //---------------put-to-basket---------------//
	function put_to_basket ($showdates="false") {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
 $xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<PutItemToBasket version=\"1.1\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<HideEventDateInBasket>".$showdates."</HideEventDateInBasket>
	</Request>
</PutItemToBasket>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	return $out_rows_data;
 }
 //---------------put-to-basket-end-----------//
 //---------------get_basket------------------//
 /**
	 * Retrieves the basket contents
	 * <br>Returns the result of the transaction in a raw array recieved from the system.
	 * @return Array
	 * @access Private
	 */
 function get_basket ($paymethod="") {
		if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	if (intval($paymethod)==0) $paymethod = "";
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
	$xml_in .= "<GetBasketContents version=\"1\">";
	//if (!empty($paymethod)) $xml_in .= "<GetBasketContents version=\"1.3\">";
	//else $xml_in .= "<GetBasketContents version=\"1\">";
	$xml_in .= "
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
";
	if (!empty($paymethod)) $xml_in .= "<MerchantID>".$paymethod."</MerchantID>";
	else $xml_in .= "<MerchantID>0</MerchantID>";
	$xml_in .= "<GetTicketExtInfo>true</GetTicketExtInfo>";
	$xml_in .= "</Request>
</GetBasketContents>";
	$xml_out = $this -> tixml_connect ($xml_in);
	return $xml_out;
 }
 /**
	 * Retrieves the basket contents
	 * <br>Returns the result of the transaction in a formatted array
	 * @return Array
	 */
 function get_basket_array ($paymethod="") {
	$tries = 0;
	//while ($tries<3 && ($tries==0 || $this->tixml_last_query_is_error == false)) {
	 $basket_xml = $this->get_basket($paymethod);
	 $tries++;

	//}
	$basket_data = $this->glob_tixml_to_array($basket_xml,5);
	$result = Array();
	foreach ($basket_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	$transcharge = $this->glob_tixml_to_array($basket_xml,3);
	$transcharge["EXTRA_CHARGE"] = $this->tixml_extra_charge;
	$result2 = $transcharge;
	$result2['ITEMS'] = $result;
	if ($this->basket_tracking_enabled==1) $this->monitor_basket($result2);
	return $result2;
 }
 /**
	 * Generates some information from the basket array
	 * <br>This function is not finished
	 * @return Array
	 * @access Private
	 */
 function get_basket_info ($basketarray) {
	$result = Array();
	$result['TRANSCHARGE'] = $basketarray['TRANSCHARGEVALUE'][0];
	$result['ITEMCOUNT'] = count($basketarray['ITEMS']);
	$result['ITEMRATES'] = Array();
	$result['ITEMRATE_COUNT'] = 0;
	$result['ITEMPRICE_SUM'] = 0;
	foreach ($basketarray['ITEMS'] as $itemnum=>$actitem) {
	 $result['ITEMPRICE_SUM'] += $actitem['PRICE'];
	 $result['ITEMRATES'][$itemnum] = $this->get_basket_avail_rates_array($itemnum, $actitem['VENUEID']);
	 $result['ITEMRATE_COUNT'] += count($result['ITEMRATES'][$itemnum]);
	}
	//$result['ITEMS'] = $basketarray['ITEMS'];
	//$result['ITEMCOUNT']
	return $result;
 }
 //---------------get_basket_end--------------//
 //---------------del_basket_item-------------//
 /**
	 * Deletes the specified item from the basket
	 * <br>Returns the result of the transaction in a raw array recieved from the system.
	 * @param Int $basket_id Basket item ID
	 * @return Array
	 * @access Private
	 */
 function del_basket_item ($basket_id) {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	$xml_in= "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<DelItemFromBasket version=\"1\">
	<Request>
	 <BrowserID>".$this->tixml_browser_id."</BrowserID>
	 <Basket_id>".$basket_id."</Basket_id>
	</Request>
</DelItemFromBasket>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$out_rows_data = $this->glob_tixml_to_array($xml_out,3);
	return $out_rows_data;
 }
 /**
	 * Deletes the specified item from the basket
	 * <br>Returns the result of the transaction in a raw array recieved from the system.
	 * @param Int $basket_id Basket item ID
	 * @return Array
	 */
 function del_basket_item_array ($basket_id) {
	$rates_data = $this->del_basket_item ($basket_id);
	$result = Array();
	foreach ($rates_data as $fieldname => $fields) {
	 foreach ($fields as $num => $value) {
		$result[$num][$fieldname] = $value;
	 }
	}
	return $result;
 }
 //---------------del_basket_item_end---------//
 //---------------get_basket_avail_rates------//
 /**
	 * Gets the available rates for the specified Basket item
	 * <br>Returns the result of the transaction in a raw array recieved from the system.
	 * @param Int $basket_id Basket item ID
	 * @param Int $venue_id Venue ID
	 * @return Array
	 * @access Private
	 */
 function get_basket_avail_rates ($basket_id, $venue_id) {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetAvailNetEventRates version=\"1\">
	<Request>
	 <BrowserID>".$this->tixml_browser_id."</BrowserID>
	 <Venue_id>".$venue_id."</Venue_id>
	 <Basket_id>".$basket_id."</Basket_id>
	</Request>
</GetAvailNetEventRates>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	return $out_rows_data;
 }
 /**
	 * Gets the available rates for the specified Basket item
	 * <br>Returns the result of the transaction in a formatted array
	 * @param Int $basket_id Basket item ID
	 * @param Int $venue_id Venue ID
	 * @return Array
	 */
 function get_basket_avail_rates_array ($basket_id, $venue_id) {
	$rates_data = $this->get_basket_avail_rates ($basket_id, $venue_id);
	$result = Array();
	foreach ($rates_data as $fieldname => $fields) {
	 foreach ($fields as $num => $value) {
		$result[$num][$fieldname] = $value;
	 }
	}
	return $result;
 }
 //---------------get_basket_avail_rates_end--//
 //---------------set_basket_rate-------------//
 /**
	 * Inserts a rate to a basket item
	 * <br>Returns the result of the transaction in a raw array recieved from the system.
	 * @param Int $itemid Basket item ID
	 * @param Int $rate Rate ID OR Rate Array
	 * @param Int $venueid Item Venus ID
	 * @return Array
	 * @access Private
	 */
 function set_basket_rate ($itemid, $rate="0", $venueid="") {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	if ($rate=="0") $rate = Array("RATE_ID"=>"0","NAME"=>"","CALCTYPE"=>"0","VALUE"=>"0");
	if (!is_array($rate) && $venueid=="") {
	 $events_array = $this->get_basket_array();
	 $rates_array = $this->get_basket_avail_rates_array($itemid, $events_array[$itemid]['VENUEID']);
	 foreach ($rates_array as $actrate) {
		if ($actrate['RATE_ID']==$rate) $rate = $actrate;
	 }
	} else if (!is_array($rate) && $venueid!=="") {
	 $rates_array = $this->get_basket_avail_rates_array($itemid, $venueid);
	 foreach ($rates_array as $actrate) {
		if ($actrate['RATE_ID']==$rate) $rate = $actrate;
	 }
	}
	$xml_in= "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<InsertRateToBasket version=\"1\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<Basket_id>".$itemid."</Basket_id>
		<Rate_id>".$rate['RATE_ID']."</Rate_id>
		<Name>".$this->CDATAifneeded($rate['NAME'])."</Name>
		<CalcType>".$rate['CALCTYPE']."</CalcType>
		<Value>".$rate['VALUE']."</Value>
	</Request>
</InsertRateToBasket>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$out_rows_data = $this->glob_tixml_to_array($xml_out,3);
	return strtolower($out_rows_data['ISSUCCESS'][0]);
 }
 /**
	 * Inserts a rate to a basket item
	 * <br>Returns the result of the transaction in a formatted array
	 * @param Int $itemid Basket item ID
	 * @param Int $rate Rate ID OR Rate Array
	 * @param Int $venueid Item Venus ID
	 * @return Array
	 */
 function set_basket_rate_array ($itemid, $rate="0", $venueid="") {
	$rates_data = $this->set_basket_rate ($itemid, $rate, $venueid);
	$result = Array();
	foreach ($rates_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	return $result;
 }
 //---------------set_basket_rate-end---------//
 //---------------get_shipping_charge--------//
 /**
	 * Gets logistics data for basket
	 * <br>Returns the result of the transaction in a raw array recieved from the system.
	 * @param Int $countryid Country ID
	 * @param Int $shippingmodeid Shipping Mode ID
	 * @param Int $quantity Item Quantity
	 * @return Array
	 * @access Private
	 */
	function get_shipping_charge ($countryid="1", $shippingmodeid="1", $quantity="0") {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	 $xml_in= "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetShippingCharge version=\"1\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<CountryID>".$countryid."</CountryID>
		<ShippingModeID>".$shippingmodeid."</ShippingModeID>
		<ItemQuantity>".$quantity."</ItemQuantity>
	</Request>
</GetShippingCharge>";
	 $xml_out = $this -> tixml_connect ($xml_in);
	 $out_rows_data = $this->glob_tixml_to_array($xml_out,3);
	 return $out_rows_data;
	}
	/**
	 * Gets logistics data for basket
	 * <br>Returns the result of the transaction in a formatted array
	 * @param Int $countryid Country ID
	 * @param Int $shippingmodeid Shipping Mode ID
	 * @param Int $quantity Item Quantity
	 * @return Array
	 */
	function get_shipping_charge_array ($countryid="1", $shippingmodeid="1", $quantity="0") {
	 $shipping_data = $this->get_shipping_charge ($countryid, $shippingmodeid, $quantity);
	 $result = Array();
	 foreach ($shipping_data as $fieldname => $fields) {
		 foreach ($fields as $num => $value) {
			$result[$fieldname] = $value;
		 }
	 }
	 return $result;
	}
 //---------------get_shipping_charge-end----//
 //---------------buy_basket_content----------//
 /**
	 * Makes the transaction in the system
	 * <br>Returns the result of the transaction in a raw array recieved from the system.
	 * @param String $firstname Customer First name OR function parameters in one Array
	 * @param String $lastname Customer Last name
	 * @param String $country Customer Country
	 * @param String $city Customer City
	 * @param String $street Customer Street
	 * @param String $zip Customer Zip Code
	 * @param String $phone Customer Phone Number
	 * @param String $email Customer E-mail Address
	 * @param String $cname Customer Name on Card
	 * @param String $cnum Customer Card Number
	 * @param String $cexpy Customer Card Expiration Year
	 * @param String $cexpm Customer Card Expiration Month
	 * @param String $cver Customer Card Verification Code
	 * @param String $online Online Transaction (default=true change only if you know what you're doing!)
	 * @param String $isvouchered If the transaction is vouchered (default=false)
	 * @param String $mailout If the transaction is a mailout transaction (default=false change only if you know what you're doing!)
	 * @param String $vouchercode Unique Voucher Code (Leave Blank for defaul voucher code generation)
	 * @param String $paypath Payment Path (Leave blank for default)
	 * @return Array
	 * @access Private
	 */
 function buy_basket_content ($firstname, $lastname="", $country="", $city="", $street="", $zip="", $phone="", $email="", $cname="", $cnum="", $cexpy="", $cexpm="", $cver="", $online='true', $isvouchered='false', $mailout='false', $vouchercode="", $paypath="") {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	if (is_array($firstname)) {
	// getting basket
	global $site_pay_creditcard_channel;
	$paymeth_to_id = Array("CCARD"=>$site_pay_creditcard_channel, "CMPS"=>23, "PAYPALEC"=>37, "CASH"=>0 );
	$paymethid = (isset($_SESSION['basket_paymethod']) && isset($paymeth_to_id[$_SESSION['basket_paymethod']]) ) ? $paymeth_to_id[$_SESSION['basket_paymethod']] : false;
	if ($paymethid===false || intval($site_pay_creditcard_channel)==0) $paymethid = 0;
		$firstname['basket_contents'] = $this->get_basket_array($paymethid);
	// setting other log data
		$firstname['browser_id'] = $this->tixml_browser_id;
		$firstname['client_ip'] = $_SERVER['REMOTE_ADDR'];
		$inarray = $firstname;
		$isvouchered = $firstname['isvouchered'];
		$creditcard = isset($firstname['creditcardpay']) ? $firstname['creditcardpay'] : $firstname['online'];
		$online = $firstname['online'];
		$lastname = $firstname['lastname'];
		$country = $firstname['country'];
		$city = $firstname['city'];
		$street = $firstname['street'];
		$zip = $firstname['zip'];
		$phone = $firstname['phone'];
		$email = $firstname['email'];
		$cname = $firstname['cname']=="" ? "" : $firstname['cname'];
		$cnum = $firstname['cnum']=="" ? "" : $firstname['cnum'];
		$cexpy = $firstname['cexpy']=="" ? "" : $firstname['cexpy'];
		$cexpm = $firstname['cexpm']=="" ? "" : $firstname['cexpm'];
		$cver = $firstname['cver']=="" ? "" : $firstname['cver'];
		$mailout = $firstname['mailout'];
		$paypath = $firstname['paypath'];
		$successfulUrl = $firstname['successfulUrl'];
		$deliverymsg = $firstname['deliverymsg'];
		$vouchercode = $firstname['vouchercode'];
		$deliverycharge = $firstname['deliverycharge'];
		//shippping data
		$uselogistics = isset($firstname['uselogistics']) ? $firstname['uselogistics'] : "false";
		$sd_firstname = isset($firstname['sd_firstname']) ? $firstname['sd_firstname'] : "";
		$sd_lastname = isset($firstname['sd_lastname']) ? $firstname['sd_lastname'] : "";
		$sd_email = isset($firstname['sd_email']) ? $firstname['sd_email'] : "";
		$sd_country_name = isset($firstname['sd_country_name']) ? $firstname['sd_country_name'] : "";
		$sd_city = isset($firstname['sd_city']) ? $firstname['sd_city'] : "";
		$sd_street = isset($firstname['sd_street']) ? $firstname['sd_street'] : "";
		$sd_zip = isset($firstname['sd_zip']) ? $firstname['sd_zip'] : "";
		$sd_phone = isset($firstname['sd_phone']) ? $firstname['sd_phone'] : "";
		$sd_description = isset($firstname['sd_description']) ? $firstname['sd_description'] : "";
		$sd_country_id = isset($firstname['sd_coutry_id']) ? $firstname['sd_coutry_id'] : "";
		$sd_shippingmode = isset($firstname['sd_shippingmode']) ? $firstname['sd_shippingmode'] : "";
		// invoice data
		$inv_NeedInvoice = isset($firstname['NeedInvoice']) ? $firstname['NeedInvoice'] : "false";
		$inv_SetInvoiceClientData = isset($firstname['InvoiceClientData']) ? "true" : "false";
		$inv_InvoiceClientData = isset($firstname['InvoiceClientData']) ? $firstname['InvoiceClientData'] : Array();

		$syschargename = "SYSCHARGE";
		if ($paypath=="CMPS") $syschargename="Kezelési költség";
		//
		$firstname = $firstname['firstname'];
	}
	if (!isset($deliverycharge) || $deliverycharge=="") $deliverycharge = 0;
	if ($uselogistics=="true") $deliverycharge = 0;
	$extracharges = "";

	$basketcontents = $this->get_basket_array();
	foreach ($basketcontents['ITEMS'] as $item) {
	 $hchargevalue = $this->determineExtraCharge($this->tixml_extra_charge, $item);
	 if ($deliverycharge>0) {
		$hchargevalue += $deliverycharge;
		$deliverycharge = 0;
	 }
	 /*var_dump($hchargevalue);
	 die();*/
	 if (floatval($hchargevalue)>0) {
		$entchargename = $paypath=="CMPS" ? $syschargename.withcurrency($hchargevalue) : $syschargename;
		$hchargevalue = str_replace(".",",",$hchargevalue);
		$extracharges .= "
		 <BasketItem>
			<Basket_id>".$item['BASKETID']."</Basket_id>
			<HChargeName>".$entchargename."</HChargeName>
			<HChargeValue>".$hchargevalue."</HChargeValue>
			<HChargeCalcType>1</HChargeCalcType>
		 </BasketItem>";
	 }
	}
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<BuyBasketContent version=\"2\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<IsVouchered>".$isvouchered."</IsVouchered>
		<Voucher>".$vouchercode."</Voucher>
		<CreditCardPay>".$creditcard."</CreditCardPay>
		<OnlineCardPay>".$online."</OnlineCardPay>
		<CCardPayPath>".$paypath."</CCardPayPath>
		<CustFirstName>".$this->CDATAifneeded($firstname)."</CustFirstName>
		<CustLastName>".$this->CDATAifneeded($lastname)."</CustLastName>
		<CustCountry>".$this->CDATAifneeded($country)."</CustCountry>
		<CustCity>".$this->CDATAifneeded($city)."</CustCity>
		<CustStreet>".$this->CDATAifneeded($street)."</CustStreet>
		<CustZip>".$zip."</CustZip>
		<CustPhone>".$phone."</CustPhone>
		<CustEmail>".$this->CDATAifneeded($email)."</CustEmail>
	<CustNotifyEmail>false</CustNotifyEmail>
		<CustCardName>".$cname."</CustCardName>
		<CustCardNum>".$cnum."</CustCardNum>
		<CustCardExpireY>".$cexpy."</CustCardExpireY>
		<CustCardExpireM>".$cexpm."</CustCardExpireM>
		<CustCardVerify>".$cver."</CustCardVerify>
		<CustIssueNum></CustIssueNum>
		<IssuerBankName></IssuerBankName>
		<MailOut>".$mailout."</MailOut>
		<UseLogisticsSystem>".$uselogistics."</UseLogisticsSystem>
		<ShippingData>
			<FirstName>".$this->CDATAifneeded($sd_firstname)."</FirstName>
			<LastName>".$this->CDATAifneeded($sd_lastname)."</LastName>
			<CountryID>".$sd_country_id."</CountryID>
			<CountryName>".$this->CDATAifneeded($sd_country_name)."</CountryName>
			<City>".$this->CDATAifneeded($sd_city)."</City>
			<Street>".$this->CDATAifneeded($sd_street)."</Street>
			<Zip>".$sd_zip."</Zip>
			<Phone>".$this->CDATAifneeded($sd_phone)."</Phone>
			<Description>".$this->CDATAifneeded($sd_description)."</Description>
			<ShippingModeID>".$sd_shippingmode."</ShippingModeID>
			<Email>".$sd_email."</Email>
		</ShippingData>
		<AccessCardCode></AccessCardCode>
		<AccessCardTypeID>0</AccessCardTypeID>
		<BasketHCharge>
		".$extracharges."
		</BasketHCharge>
		<PayMerchantURL>
					<SuccessfulUrl>".$successfulUrl."</SuccessfulUrl>
					<FailUrl></FailUrl>
					<TryLaterUrl></TryLaterUrl>
					<ErrorUrl></ErrorUrl>
		</PayMerchantURL>
		<EndUserIP>".$_SERVER['REMOTE_ADDR']."</EndUserIP>
		<DeliveryMsg>".$deliverymsg."</DeliveryMsg>
	<MobilChannelType>0</MobilChannelType>
	<SendSM>false</SendSM>
	<ExtParams></ExtParams>
	<NeedInvoice>".$inv_NeedInvoice."</NeedInvoice>
	<SetInvoiceClientData>".$inv_SetInvoiceClientData."</SetInvoiceClientData>
	<InvoiceClientData>
		<Name>".$inv_InvoiceClientData['Name']."</Name>
		<TaxNumber>".$inv_InvoiceClientData['TaxNumber']."</TaxNumber>
		<EUTaxNumber>".$inv_InvoiceClientData['EUTaxNumber']."</EUTaxNumber>
		<Country>".$inv_InvoiceClientData['Country']."</Country>
		<City>".$inv_InvoiceClientData['City']."</City>
		<Zipcode>".$inv_InvoiceClientData['Zipcode']."</Zipcode>
		<Street>".$inv_InvoiceClientData['Street']."</Street>
		<StreetType>".$inv_InvoiceClientData['StreetType']."</StreetType>
		<HouseNumber>".$inv_InvoiceClientData['HouseNumber']."</HouseNumber>
		<Building>".$inv_InvoiceClientData['Building']."</Building>
		<Staircase>".$inv_InvoiceClientData['Staircase']."</Staircase>
		<Floor>".$inv_InvoiceClientData['Floor']."</Floor>
		<Door>".$inv_InvoiceClientData['Door']."</Door>
	</InvoiceClientData>
	<PayPathProp>0</PayPathProp>
	</Request>
</BuyBasketContent>";
	$bind = date("Y")."-".date("m")."-".date("d")."_".date("H")."-".date("i")."-".date("s")."_".$this->tixml_browser_id;
	$this->transbind = $bind;
	if (!file_exists($this->logobj->logdir."pay/")) mkdir($this->logobj->logdir."pay/", 0777, true);
	$xml_in_loggable = preg_replace_callback ('[<CustCardNum>(.*)(.{4})</CustCardNum>]', Array($this, "starout"), $xml_in);
	$filename = "pay_".$this->transbind;
	$this->log($filename, $xml_in_loggable, "pay/in/");
	if (empty($firstname) || empty($lastname) || empty($email)) {
		$xml_out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<BuyBasketContentResponse version=\"2\">
<BuildDate>".date("Y. m. d. H:i:s")."</BuildDate>
<Response>
	<IsSuccess>false</IsSuccess>
	<ErrorMessage>Empty required property</ErrorMessage>
</Response>
</BuyBasketContentResponse>";
	} else {
		$lasttimeout = $this -> tixml_timeout;
		ini_set("max_execution_time", "650");
		ignore_user_abort();
		$this -> tixml_timeout = 600;
		$xml_out = $this -> tixml_connect ($xml_in);
		$this -> tixml_timeout = $lasttimeout;
	}
	$this->log($filename, $xml_in_loggable."\r\n\r\n".$xml_out, "pay/");
	$xml_out = str_replace("&amp;", $this->CDATAifneeded("&"), $xml_out);
	$this->log($filename, $xml_out, "pay/out/");
	$out_rows_data = $this->glob_tixml_to_array($xml_out,3);
	 if (!file_exists($this->logobj->logdir."transactions_ser")) mkdir($this->logobj->logdir."transactions_ser/", 0777, true);
	 if (!file_exists($this->logobj->logdir."transactions_ser/in")) mkdir($this->logobj->logdir."transactions_ser/in", 0777, true);
	 if (!file_exists($this->logobj->logdir."transactions_ser/out")) mkdir($this->logobj->logdir."transactions_ser/out", 0777, true);
	if (isset($out_rows_data['ISSUCCESS']) && strtolower($out_rows_data['ISSUCCESS'][0])=="true" && strtolower($out_rows_data['LASTRESULT'][0])=="true") {
	 $this->log($filename, $xml_in_loggable."\r\n\r\n".$xml_out, "transactions/");
	 $this->log($filename, $xml_in_loggable, "transactions/in/");
	 $this->log($filename, $xml_out, "transactions/out/");
	 $inarray['cnum'] = $this->starout($inarray['cnum']);
	 if (isset($GLOBALS['basket_information'])) $inarray['basket_information'] = $GLOBALS['basket_information'];
	 saveconfig("pay", $bind, $inarray, $this->logobj->logdir."transactions_ser/");
	 saveconfig("pay", $bind, $inarray, $this->logobj->logdir."transactions_ser/in/");
	 saveconfig("pay", $bind, $out_rows_data, $this->logobj->logdir."transactions_ser/out/");
	} else {
	 $this->log($filename, $xml_in_loggable."\r\n\r\n".$xml_out, "temp/transactions/");
	 $this->log($filename, $xml_in_loggable, "temp/transactions/in/");
	 $this->log($filename, $xml_out, "temp/transactions/out/");
	 $inarray['cnum'] = $this->starout($inarray['cnum']);
	 saveconfig("pay", $bind, $inarray, $this->logobj->logdir."temp/transactions_ser/");
	 saveconfig("pay", $bind, $inarray, $this->logobj->logdir."temp/transactions_ser/in/");
	 saveconfig("pay", $bind, $out_rows_data, $this->logobj->logdir."temp/transactions_ser/out/");
	}
	if ($this->basket_tracking_enabled==1) $this->monitor_sale($out_rows_data, true);
	return $out_rows_data;
 }
 /**
	 * Makes the transaction in the system
	 * <br>Returns the result of the transaction in a formatted array.
	 * @param String $firstname Customer First name OR function parameters in one Array
	 * @param String $lastname Customer Last name
	 * @param String $country Customer Country
	 * @param String $city Customer City
	 * @param String $street Customer Street
	 * @param String $zip Customer Zip Code
	 * @param String $phone Customer Phone Number
	 * @param String $email Customer E-mail Address
	 * @param String $cname Customer Name on Card
	 * @param String $cnum Customer Card Number
	 * @param String $cexpy Customer Card Expiration Year
	 * @param String $cexpm Customer Card Expiration Month
	 * @param String $cver Customer Card Verification Code
	 * @param String $online Online Transaction (default=true change only if you know what you're doing!)
	 * @param String $isvouchered If the transaction is vouchered (default=false)
	 * @param String $mailout If the transaction is a mailout transaction (default=false change only if you know what you're doing!)
	 * @param String $vouchercode Unique Voucher Code (Leave Blank for defaul voucher code generation)
	 * @param String $paypath Payment Path (Leave blank for default)
	 * @return Array
	 * @access Private
	 */
 function buy_basket_content_array ($firstname, $lastname, $country, $city, $street, $zip, $phone, $email, $cname, $cnum, $cexpy, $cexpm, $cver, $online='true', $isvouchered='false', $mailout='false', $vouchercode="", $paypath="") {
	$buybasket_data = $this->buy_basket_content($firstname, $lastname, $country, $city, $street, $zip, $phone, $email, $cname, $cnum, $cexpy, $cexpm, $cver, $online, $isvouchered, $mailout, $vouchercode, $paypath);
	$result = Array();
	foreach ($buybasket_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	return $result;
 }
 function finalize_transaction_logs ($custombind) {
	if (!empty($custombind)) $filename = "pay_".$custombind;
	else $filename = "pay_".$this->transbind;
	 $this->logobj->move_log($filename, "temp/transactions/", $filename, "transactions/");
	 $this->logobj->move_log($filename, "temp/transactions/in/", $filename, "transactions/in/");
	 $this->logobj->move_log($filename, "temp/transactions/out/", $filename, "transactions/out/");
	 if (!file_exists($this->logobj->logdir."transactions_ser")) mkdir($this->logobj->logdir."transactions_ser/", 0777, true);
	 if (!file_exists($this->logobj->logdir."transactions_ser")) mkdir($this->logobj->logdir."transactions_ser/in", 0777, true);
	 if (!file_exists($this->logobj->logdir."transactions_ser")) mkdir($this->logobj->logdir."transactions_ser/out", 0777, true);
	 ser_move("pay", $this->transbind, $this->logobj->logdir."temp/transactions_ser/", "pay", $this->transbind, $this->logobj->logdir."transactions_ser/");
	 ser_move("pay", $this->transbind, $this->logobj->logdir."temp/transactions_ser/in/", "pay", $this->transbind, $this->logobj->logdir."transactions_ser/in/");
	 ser_move("pay", $this->transbind, $this->logobj->logdir."temp/transactions_ser/out/", "pay", $this->transbind, $this->logobj->logdir."transactions_ser/out/");
 }
 function remove_transaction_logs ($custombind) {
	if (!empty($custombind)) $filename = "pay_".$custombind;
	else $filename = "pay_".$this->transbind;
	 $this->logobj->del_log($filename, "temp/transactions/");
	 $this->logobj->del_log($filename, "temp/transactions/in/");
	 $this->logobj->del_log($filename, "temp/transactions/out/");
	 ser_delete("pay", $this->transbind, $this->logobj->logdir."temp/transactions_ser/");
	 ser_delete("pay", $this->transbind, $this->logobj->logdir."temp/transactions_ser/in/");
	 ser_delete("pay", $this->transbind, $this->logobj->logdir."temp/transactions_ser/out/");
 }
 //---------------buy_basket_content-end------//
 //---------------get_pay_result----------------//
 /**
	 * Returns the result of the transaction
	 * <br>Returns the result of the transaction in a raw array recieved from the system.
	 * <br>This function may only be used with async payments
	 * @param Int $browserid Browser ID
	 * @return Array
	 * @access Private
	 */
 function get_pay_result ($browserid="") {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	if ($browserid=="") $browserid = $this->browser_id;
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetLastPayTrans version=\"1\">
	<Request>
		<BrowserID>".$browserid."</BrowserID>
	</Request>
</GetLastPayTrans>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$this->log("pay_".$this->transbind, $xml_in.'\n'.$xml_out, "pay/");
	$out_rows_data = $this->glob_tixml_to_array($xml_out, 3);
	if ($this->basket_tracking_enabled==1) $this->monitor_sale($out_rows_data);
	return $out_rows_data;
 }
 /**
	 * Returns the result of the transaction
	 * <br>Returns the result of the transaction in a formatted array.
	 * <br>This function may only be used with async payments
	 * @param Int $browserid Browser ID
	 * @return Array
	 */
 function get_pay_result_array ($browserid="") {
	$trans_data = $this->get_pay_result ($browserid);
	$result = Array();
	foreach ($trans_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	return $result;
 }
 //---------------get_pay_result-end------------//
 //---------------print_ticket----------------//
 /**
	 * Prints the PDF tickets of a transaction
	 * <br>Returns the data of the tickets in a raw array recieved from the system.
	 * @param Int $transid Transaction ID
	 * @param Boolean $netvoucher If to print a PDF Voucher
	 * @param Int $decimals Number of decimals in the values on the PDF. Default=0
	 * @param Int $language Language Code of the PDF fields. Default=2
	 * @return Array
	 * @access Private
	 */
 function print_ticket ($transid, $netvoucher="false", $decimals="0", $language="2") {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	if (empty($language)) $language = 2;
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<TicketPrint version=\"1\">
	<Request>
	 <BrowserID>".$this->tixml_browser_id."</BrowserID>
	 <TransactionID>".$transid."</TransactionID>
	 <ReportPrintStreamMode>PDF</ReportPrintStreamMode>
	 <TicketPrintLanguage>".$language."</TicketPrintLanguage>
	 <TicketPriceCurrencyDecimals>".$decimals."</TicketPriceCurrencyDecimals>
	 <NetVoucher>".$netvoucher."</NetVoucher>
	</Request>
</TicketPrint>";
	$timeouttmp = $this->tixml_timeout;
	$this->tixml_timeout = max(180, $timeouttmp);
	$xml_out = $this -> tixml_connect ($xml_in);
	$this->tixml_timeout = $timeouttmp;
	$out_rows_data = $this->glob_tixml_to_array($xml_out,4);
	//$this->log("test", $xml_in.$xml_out);
	$this->log("ticket_print", $xml_in."\r\n".$xml_out);
	if (count($out_rows_data['TICKETIDS'])>0) {
	 $filename = "print_".$this->transbind;
	 $this->log($filename, $xml_in."\r\n\r\n".$xml_out, "ticketprint/");
	 $this->log($filename, $xml_in, "ticketprint/in/");
	 $this->log($filename, $xml_out, "ticketprint/out/");
	 $inarray=Array("browser_id"=>$this->tixml_browser_id, "transid"=>$transid, "netvoucher"=>$netvoucher, "decimals"=>$decimals, "language"=>$language);
	 $bind = $this->transbind;
	 saveconfig("print", $bind, $out_rows_data, $this->logobj->logdir."ticketprint_ser/");
	 saveconfig("print", $bind, $inarray, $this->logobj->logdir."ticketprint_ser/in/");
	 saveconfig("print", $bind, $out_rows_data, $this->logobj->logdir."ticketprint_ser/out/");
	}
	return $out_rows_data;
 }
 /**
	 * Prints the PDF tickets of a transaction
	 * <br>Returns the data of the tickets in formatted array.
	 * @param Int $transid Transaction ID
	 * @param Boolean $netvoucher If to print a PDF Voucher
	 * @param Int $decimals Number of decimals in the values on the PDF. Default=0
	 * @param Int $language Language Code of the PDF fields. Default=2
	 * @return Array
	 */
 function print_ticket_array ($transid, $netvoucher="false", $decimals="0", $language="1") {
	$ticket_data = $this->print_ticket ($transid, $netvoucher, $decimals, $language);
	$result = Array();
	foreach ($ticket_data as $fieldname => $fields) {
		foreach ($fields as $num => $value) {
		 $result[$num][$fieldname] = $value;
		}
	 }
	return $result;
 }
 //---------------print_ticket-end------------//

 //---------------deadline_expand-------------//
 /**
	 * Expands the session time of the basket
	 * <br>Returns true if succesful
	 * @return Boolean
	 */
 function deadline_expand () {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<SessionDeadLineExpand version=\"1\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
	</Request>
</SessionDeadLineExpand>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$out_rows_data = $this->glob_tixml_to_array($xml_out,3);
	$result = strtolower($out_rows_data['ISSUCCESS'][0])=="true" ? true : false;
	return $result;
 }
 //---------------deadline_expand-end---------//

 //---------------get_event_properties--------//
 function get_event_properties ($event_id="0", $venue_id="0") {
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetEventProperties version=\"1\">
	<Request>
		<BrowserID>".$this->tixml_browser_id."</BrowserID>
		<NetEvent_id>".$event_id."</NetEvent_id>
		<Venue_Id>".$venue_id."</Venue_Id>
 </Request>
</GetEventProperties>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$out_rows_data = $this->glob_tixml_to_array($xml_out,3);
	return $result;
 }


 //---------------client_functions-------------//
 /**
	 * Registers client
	 * <br>Returns array
	 * @return Array
	 */
 function register_client ($firstname, $lastname, $name, $email, $password, $country, $city, $zip, $street, $phone) {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	 if ( is_array($firstname) ) {
		$email = $firstname['Email'];
		$password = $firstname['Password'];
		$nickname = $firstname['NickName'];
		$lastname = $firstname['LastName'];
		$country = $firstname['Country'];
		$city = $firstname['City'];
		$zip = $firstname['Zip'];
		$street = $firstname['Street'];
		$phone = $firstname['Phone'];
		$newpassword = $firstname['PasswordModify'];
		$company = $firstname['Company'];
		$remark = $firstname['Remark'];
		$firstname = $firstname['FirstName'];
		if (is_bool($name['Newsletter'])) $name['Newsletter'] = $name['Newsletter']==true ? "true" : "false";
		if (!isset($name['Newsletter'])) $newsletter = "false";
		else $newsletter = $name['Newsletter'];
	 }
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<ClientRegistration version=\"1\">
	<Request>
		<FirstName>".$firstname."</FirstName>
		<LastName>".$lastname."</LastName>
		<NickName>".$nickname."</NickName>
		<Company>".$company."</Company>
		<Phone>".$phone."</Phone>
		<Email>".$email."</Email>
		<Password>".$password."</Password>
		<Country>".$country."</Country>
		<City>".$city."</City>
		<ZipCode>".$zip."</ZipCode>
		<Street>".$street."</Street>
		<Remark>".$remark."</Remark>
		<NewsLetterReq>".$newsletter."</NewsLetterReq>
		<OwnerUserName>".strtoupper($this->tixml_login)."</OwnerUserName>
	<OwnerUserPwd>".md5($this->hashsalt.strtoupper($this->tixml_password))."</OwnerUserPwd>
	</Request>
</ClientRegistration>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$result = $this -> getXmlArray($xml_out);
	return $result;
 }
 /**
	 * Get client data
	 * <br>Returns client data array
	 * @return Array
	 */
 function get_client ($email, $password, $connected=false) {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	$bid = $connected===true ? $this->tixml_browser_id : "";
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetClient version=\"1\">
	<Request>
		<BrowserID>".$bid."</BrowserID>
		<Email>".$email."</Email>
		<Password>".$password."</Password>
	<OwnerUserName>".strtoupper($this->tixml_login)."</OwnerUserName>
	<OwnerUserPwd>".md5($this->hashsalt.strtoupper($this->tixml_password))."</OwnerUserPwd>
	</Request>
</GetClient>";
//echo $xml_in;
	$xml_out = $this -> tixml_connect ($xml_in);
	$result = $this -> getXmlArray($xml_out);
	return $result;
 }

 function set_client ($bid="", $email="", $password="") {
	if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	$bid = empty($bid) ? $this->tixml_browser_id : $bid;
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<AssignClientToBasket version=\"1\">
	<Request>
		<BrowserID>".$bid."</BrowserID>
		<Email>".$email."</Email>
		<Password>".$password."</Password>
	<OwnerUserName>".strtoupper($this->tixml_login)."</OwnerUserName>
	<OwnerUserPwd>".md5($this->hashsalt.strtoupper($this->tixml_password))."</OwnerUserPwd>
	</Request>
</AssignClientToBasket>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$result = $this -> getXmlArray($xml_out);
	return $result;
 }

 /**
	 * Update client data
	 * <br>Returns array
	 * @return Array
	 */
 function update_client ($firstname, $lastname, $name, $email, $password, $country, $city, $zip, $street, $phone, $newpassword="") {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	 if ( is_array($name) ) {
		$email = $firstname;
		$password = $lastname;
		$firstname = $name['FirstName'];
		$lastname = $name['LastName'];
		$country = $name['Country'];
		$city = $name['City'];
		$zip = $name['Zip'];
		$street = $name['Street'];
		$phone = $name['Phone'];
		$newpassword = $name['PasswordModify'];
		$company = $name['Company'];
		$remark = $name['Remark'];
		if (is_bool($name['Newsletter'])) $name['Newsletter'] = $name['Newsletter']==true? "true" : "false";
		if (!isset($name['Newsletter'])) $newsletter = "false";
		else $newsletter = $name['Newsletter'];
	}

	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<UpdateClient version=\"1\">
	<Request>
		<FirstName>".$firstname."</FirstName>
		<LastName>".$lastname."</LastName>
		<NickName>".$nickname."</NickName>
		<Company>".$company."</Company>
		<Phone>".$phone."</Phone>
		<Email>".$email."</Email>
		<Password>".$password."</Password>
		<Country>".$country."</Country>
		<City>".$city."</City>
		<Zip>".$zip."</Zip>
		<Street>".$street."</Street>
		<Remark>".$remark."</Remark>
		<NewsLetterReq>".$newsletter."</NewsLetterReq>
		<OwnerUserName>".strtoupper($this->tixml_login)."</OwnerUserName>
	<OwnerUserPwd>".md5($this->hashsalt.strtoupper($this->tixml_password))."</OwnerUserPwd>
		<EmailModify></EmailModify>
		<PasswordModify>".$newpassword."</PasswordModify>
	</Request>
</UpdateClient>";
//echo $xml_in;
	$xml_out = $this -> tixml_connect ($xml_in);
	$result = $this -> getXmlArray($xml_out);
	return $result;
 }
 /**
	 * Get client's debit cards
	 * <br>Returns array
	 * @return Array
	 */
 function get_client_dcards ($email, $password) {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	$bid = $connected===true ? $this->tixml_browser_id : "";
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetClientDebitCards version=\"1\">
	<Request>
		<Email>".$email."</Email>
		<Password>".$password."</Password>
	<OwnerUserName>".strtoupper($this->tixml_login)."</OwnerUserName>
	<OwnerUserPwd>".md5($this->hashsalt.strtoupper($this->tixml_password))."</OwnerUserPwd>
	</Request>
</GetClientDebitCards>";
//echo $xml_in;
	$xml_out = $this -> tixml_connect ($xml_in);
	$result = $this -> getXmlArray($xml_out);
	return $result;
 }
	/**
	 * Set client's debit cards
	 * <br>Returns array
	 * @return Array
	 */
 function set_client_dcards ($email, $password, $barcode) {
	 if ($this->tixml_common_browser_id) $this->new_browser_id(true);
	$bid = $connected===true ? $this->tixml_browser_id : "";
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<ClientDiscCardReg version=\"1\">
	<Request>
		<Email>".$email."</Email>
		<Password>".$password."</Password>
	<OwnerUserName>".strtoupper($this->tixml_login)."</OwnerUserName>
	<OwnerUserPwd>".md5($this->hashsalt.strtoupper($this->tixml_password))."</OwnerUserPwd>
	<CardBarcode>".$barcode."</CardBarcode>
	</Request>
</ClientDiscCardReg>";
	$xml_out = $this -> tixml_connect ($xml_in);
	$result = $this -> getXmlArray($xml_out);
	return $result;
 }
 //---------------client_functions-end-------------//



 //---------programbrain functions-----------//

 function tixml_connect_programbrain ($xml_in) {
	if (empty($this->tixml_translator_url)) return "";
	if ($this->tixml_translator_enabled==1) {
		$srvbck = $this -> tixml_server;
		$pfxbck = $this -> tixml_prefix;
		$portbck = $this -> tixml_port;
		$this -> tixml_server = $this->tixml_translator_url;
		$this -> tixml_prefix = "";
		$this -> tixml_port = 80;
//$this->logging=1;
	 $xml_out = $this -> tixml_connect ($xml_in);
//$this->logging=0;
		$this -> tixml_server = $srvbck;
		$this -> tixml_prefix = $pfxbck;
		$this -> tixml_port = $portbck;
	}
	return $xml_out;
 }
 function tixml_cached_connect_programbrain ($xml_in, $cachefile, $cachelife=false) {
	if (empty($this->tixml_translator_url)) return "";
	 $subdir = $this->tixml_region_id."/" ;
	 if (!file_exists($this->cache_dir)) mkdir ($this->cache_dir, 0777, true);
	 $cachefile = $this->cache_dir.$subdir.$cachefile;
	 $cachelife = !$cachelife ? $this->cachelife : $cachelife;
	 if (isset($_GET['nocache']) || $this->caching==0 || !file_exists($cachefile) || filesize($cachefile)==0 || (file_exists($cachefile) && filemtime($cachefile)<time()-($cachelife*3600))) {
		// -----
		//if (!empty($this->tixml_translator_url)) {
			$srvbck = $this -> tixml_server;
			$pfxbck = $this -> tixml_prefix;
			$portbck = $this -> tixml_port;
			$this -> tixml_server = $this->tixml_translator_url;
			$this -> tixml_prefix = "";
			$this -> tixml_port = 80;

		$xml_out = $this -> tixml_connect ($xml_in);
			$this -> tixml_server = $srvbck;
			$this -> tixml_prefix = $pfxbck;
				$this -> tixml_port = $portbck;
		//}
		//-----
		if ($this->caching!==0 && strpos($xml_out, "<errormsg>")===FALSE) {
		 if (!file_exists($this->cache_dir)) mkdir($this->cache_dir, 0777, true);
		 if (!file_exists($this->cache_dir.$subdir)) mkdir($this->cache_dir.$subdir, 0777, true);
		 $handle = fopen($cachefile, "w");
	 fwrite($handle, $xml_out);
	 fclose($handle);
	}
	return $xml_out;
	 } else {
		//echo "rc-";
		$xml_out = file_get_contents($cachefile);
		return $xml_out;
	 }
 }

 function pb_get_venue_info ($venuename="", $venueid="0") {
	//translang=\"".$this->tixml_translator_lang."\"
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetVenueInfos>
 <VenueName>".$this->CDATAifneeded($venuename)."</VenueName>
 <VenueId>".$venueid."</VenueId>
</GetVenueInfos>";
	//echo $xml_in;
	if (!empty($venuename) && empty($venueid)) {
		$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "pb_venue_".md5($venuename), 1);
	} else if (!empty($venuename) || !empty($venueid) ) {
	$xml_out = $this -> tixml_connect_programbrain ($xml_in);
	} else {
		$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "pb_venues_index", 1);
	}
	return $xml_out;
 }
 function pb_get_venue_info_array ($venuename="", $venueid="0") {
	if (isset($_GET['dbg']) && $_GET['dbg']>1) echo "Venueinfo requested (".$venuename."/".$venueid.")<br>";
	$cache_id = $this->cache_dir.$this->tixml_region_id."/VenueInfo_".md5($venuename)."_".$venueid;
		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id,60*60);
		}
		if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "VenueInfo restored with CacheManager<br>";
	} else {
		$venue_data = $this->pb_get_venue_info ($venuename, $venueid);
		$result = $this->SXML_get_array($venue_data, true);
		if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, 60*60);
	}
	return $result;
 }

 function pb_get_program_info ($programid="0", $onlyactive=false, $ishighlighted="") {
	if (empty($ishighlighted)) $ishighlighted = 0;
	$onlyactive = $onlyactive ? "true" : "false";
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetProgramInfos >
 <ProgramId>".$programid."</ProgramId>
 <IsHighLighted>".$ishighlighted."</IsHighLighted>
 <OnlyActive>".$onlyactive."</OnlyActive>
</GetProgramInfos>";
	if (!empty($programid)) {
	$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "pb_program_".$programid, 0.5);
	} else {
		$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "pb_programs_index_".$onlyactive, 0.5);
	}
	return $xml_out;
 }
 function pb_get_program_info_array ($programid="0", $ishighlighted="") {
	if (isset($_GET['dbg']) && $_GET['dbg']>1) echo "Programinfo requested (".$programid."/".$ishighlighted.")<br>";
	$translang=$this->tixml_translator_lang;
	if ( is_bool($programid) ) {
			$onlyactive = $programid;
			$programid = 0;
	}
	if (empty($onlyactive)) $onlyactive = false;
	if ($onlyactive) $cache_id = $this->cache_dir.$this->tixml_region_id."/ProgramSheetActive_".$programid;
	else $cache_id = $this->cache_dir.$this->tixml_region_id."/ProgramSheet_".$programid;
	if (isset($_GET['dbg']) && $_GET['dbg']>1) echo "Cache ID:".$cache_id."<br>";

		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id, 30*60);
		}
		if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "Programinfo restored with CacheManager (".$programid.")<br>";
	} else {
		if (isset($_GET['dbg']) && $_GET['dbg']>1) echo "Programinfo loading from interface<br>";
		$st=microtime(true);
		$program_data = $this->pb_get_program_info ($programid, $onlyactive, $ishighlighted);
		$result = $this->SXML_get_array($program_data, true);
		if (!isset($result["GETPROGRAMINFOSRESPONSE"]['PROGRAM'][0])) $result["GETPROGRAMINFOSRESPONSE"]['PROGRAM'] = Array($result["GETPROGRAMINFOSRESPONSE"]['PROGRAM']);
		if ( empty($programid) ) $result["GETPROGRAMINFOSRESPONSE"]['PROGRAM'] = $this->reindex_by_field($result["GETPROGRAMINFOSRESPONSE"]['PROGRAM'], "PROGRAM_ID");
		if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, 30*60);
	}
	return $result;
 }

 function pb_get_actor_info ($actorid="0", $actorname="") {
	//translang=\"".$this->tixml_translator_lang."\"
	if (empty($actorid)) $actorid = "0";
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetActorInfos >
 <ActorId>".$actorid."</ActorId>
 <ActorName>".$actorname."</ActorName>
</GetActorInfos>";
	//echo $xml_in;
	if (!empty($actorid) && empty($actorname)) {
		$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "pb_person_".$actorid, 1);
	} else if (empty($actorid) && !empty($actorname)) {
		$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "pb_person_".md5($actorname), 1);
	} else if ( empty($actorid) && empty($actorname) ) {
		$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "pb_person_index", 1);
	}
	//$xml_out = $this -> tixml_connect_programbrain ($xml_in);
	return $xml_out;
 }
 function pb_get_actor_info_array ($actorid="0", $actorname="") {
	if (isset($_GET['dbg']) && $_GET['dbg']>1) echo "Personinfo requested (".$actorid."/".$actorname.")<br>";
	$cache_id = $this->cache_dir.$this->tixml_region_id."/PersonInfo_".$actorid."_".md5($actorname);
		if ( isset($GLOBALS['CM']) ) {
			$result = $GLOBALS['CM']->get($cache_id, 60*60);
		}
		if (!empty($result)) {
		if (isset($_GET['dbg'])) echo "PersonInfo restored with CacheManager<br>";
	} else {
		$actor_data = $this->pb_get_actor_info ($actorid, $actorname);
		$result = $this->SXML_get_array($actor_data, true);
		if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $result, 60*60);
	}
	return $result;
 }
 function get_program_translations ($programid="0", $venueid="0", $auditid="0") {
	if (!empty($this->tixml_translator_url)) {
		if (isset($_GET['dbg']) && $_GET['dbg']>1) echo "ProgramTranslations requested<br>";
		if ($venueid=="0" && $this->tixml_venue_id>0) $venueid = $this->tixml_venue_id;
		$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetProgramTranslations>
	<Program_id>".$programid."</Program_id>
	<Venue_id>".$this->tixml_venue_id."</Venue_id>
	<Audit_id>".$auditid."</Audit_id>
</GetProgramTranslations>";
		$cache_id = $this->cache_dir.$this->tixml_region_id."/programtranslations_".$programid."_".$venueid."_".$auditid;
		if ( isset($GLOBALS['CM']) ) {
			//$transtable = $GLOBALS['CM']->get($cache_id, 1*60*60);
		}
		if (empty($transtable)) {
			if (empty($programid) && empty($venueid) && empty($auditid)) {
				$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "ProgramTranslations", 1);
			} else if (!empty($programid) && empty($venueid) && empty($auditid)) {
				$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "ProgramTranslations_".md5($programid), 1 );
			} else {
				$xml_out = $this -> tixml_connect_programbrain ($xml_in);
			}
			$result = $this->SXML_get_array($xml_out, true);
			$transtable = Array();
			foreach ($result['GETPROGRAMTRANSLATIONSRESPONSE']['RESPONSE']['PROGRAMLIST'] as $acttrans) {
				$transtable[$acttrans['PROGRAM_ID']."_".strtoupper($acttrans['LANG'])] = $acttrans;
			}
			if ( isset($GLOBALS['CM']) ) $GLOBALS['CM']->set($cache_id, $transtable, 1*60*60);
		} else {
			if (isset($_GET['dbg'])) echo "Programtranslations restored with CacheManager<br>";
		}
	} else {
		$transtable = Array();
	}
	return $transtable;
 }

	function pb_get_custom_venues ($venuename="") {
	//translang=\"".$this->tixml_translator_lang."\"
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetCustomVenues >
 <VenueName>".$venuename."</VenueName>
</GetCustomVenues>";
	//echo $xml_in;
	$xml_out = $this -> tixml_cached_connect_programbrain ($xml_in, "CustomVenues");
	//$xml_out = $this -> tixml_connect_programbrain ($xml_in);
	return $xml_out;
 }
 function pb_get_custom_venues_array ($venuename="") {
	$actor_data = $this->pb_get_custom_venues ($actorid, $actorname);
	$result = $this->getXmlArray($actor_data);
	return $result;
 }

 function pb_get_sector_offsets ($venueid, $auditid) {
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetSectorOffsets>
 <Venue_id>".$venueid."</Venue_id>
 <Audit_id>".$auditid."</Audit_id>
</GetSectorOffsets>";
	//echo $xml_in;
	$xml_out = $this -> tixml_connect_programbrain ($xml_in);
	return $xml_out;
 }
 function pb_get_sector_offsets_array ($venueid, $auditid) {
	$actor_data = $this->pb_get_sector_offsets ($venueid, $auditid);
	$result = $this->getXmlArray($actor_data);
	return $result;
 }
 function pb_set_sector_offsets ($venueid, $auditid, $sectorid, $x, $y, $z, $anglex) {
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<SetSectorOffsets>
 <Venue_id>".$venueid."</Venue_id>
 <Audit_id>".$auditid."</Audit_id>
 <Sector_id>".$sectorid."</Sector_id>
 <X>".$x."</X>
 <Y>".$y."</Y>
 <Z>".$z."</Z>
 <Angle_x>".$anglex."</Angle_x>
</SetSectorOffsets>";
	//echo $xml_in;
	$xml_out = $this -> tixml_connect_programbrain ($xml_in);
	return $xml_out;
 }
 function pb_set_sector_offsets_array ($venueid, $auditid, $sectorid, $x, $y, $z, $anglex) {
	$actor_data = $this->pb_get_sector_offsets ($venueid, $auditid, $sectorid, $x, $y, $z, $anglex);
	$result = $this->getXmlArray($actor_data);
	return $result;
 }
 function pb_get_extra_sectors ($venueid, $auditid) {
	$xml_in = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<GetExtraSectors>
 <Venue_id>".$venueid."</Venue_id>
 <Audit_id>".$auditid."</Audit_id>
</GetExtraSectors>";
	//echo $xml_in;
	$xml_out = $this -> tixml_connect_programbrain ($xml_in);
	return $xml_out;
 }
 function pb_get_extra_sectors_array ($venueid, $auditid) {
	$actor_data = $this->pb_get_extra_sectors ($venueid, $auditid);
	$result = $this->getXmlArray($actor_data);
	return $result;
 }
 //---------programbrain functions-end-------//

	/**
	 * Retrieves the flash chart Url from the settings by the event data
	 * <br>This function is not used anymore
	 * @param Int $event Event ID or Event Array
	 * @return String
	 */
	function getchartlink ($event) {
	 $event = is_array($event) ? $event : $this->get_event_array("", "", "", "0", "", $event);
	 $output = $this->tixml_chart_url;
	 $output=str_replace("__BROWSERID__", $this->tixml_browser_id, $output);
	 $output=str_replace("__EVENTID__", $event['NETEVENT_ID'], $output);
	 $output=str_replace("__AUDITID__", $event['NETAUDIT_ID'], $output);
	 $output=str_replace("__VENUEID__", $event['VENUE_ID'], $output);
	 return $output;
	}
	/**
	 * Retrieves the basket Url from the settings
	 * <br>This function is not used anymore
	 * @return String
	 */
	function getbasketlink () {
	 $output = $this->tixml_basket_url;
	 $output = str_replace("__BROWSERID__", $this->tixml_browser_id, $output);
	 return $output;
	}
	/**
	 * Retrieves the binary string from a given number
	 * <br>Returns a formatted string with zeros and ones
	 * @param Int $methodcode Input Number
	 * @param Int $bits Number of the Bits in the Output
	 * @return String
	 */
	function get_binary_string ($methodcode, $bits=8) {
	 $bincode = "";
	 $pow = $bits;
	 $bin_string = base_convert($methodcode, 10, 2);
	 $bincode = str_pad($bin_string, 8, "0", STR_PAD_LEFT);
	 return $bincode;
	}

	function CDATAifneeded ($target) {
	$target_chars = "#&<>/";
	$needed = false;
	for ($i=0;$i<strlen($target_chars);$i++) {
		$actchar = substr($target_chars, $i, 1);
		if ($needed==false && strpos($target, $actchar)!==false) {
			$needed = true;
		}
	}
	if ($needed==true) {
		$target = "<![CDATA[".$target."]]>";
	}
	return $target;
	}

	function getprogramtype ($ptid, $mode=3, $divider=" / ") {
	global $language_categories, $language_subcategories;
	$subcat = strpos($ptid, "|")!==false ? substr($ptid, strpos($ptid, "|")+1) : $ptid;
	if (strpos($ptid, "|")!==false) {
		$catid = substr($ptid, 0, strpos($ptid, "|"));
	} else if ($subcat==0) {
		$catid = 0;
	} else if ($subcat<=7) {
		$catid = 1;
	} else if ($subcat>7 && $subcat<19) {
		$catid = 2;
	} else if ($subcat>18 && $subcat<28) {
		$catid = 3;
	} else if ($subcat>27 && $subcat<30) {
		$catid = 4;
	} else {
		$catid = 5;
	}
	$catname = $language_categories[$catid];
	$subcatname = intval($subcat)>0 ? "" : $language_subcategories[$subcat];
	//echo $catid." - ".$subcat;
	if ($mode==3) {
		$result = $catname;
		if (intval($subcat)>0) $result .= $divider.$subcatname;
	} else if ($mode==2) {
		$result = $subcatname;
	} else if ($mode==1) {
		$result = $catname;
	} else if ($mode==0) {
		$result = $catid;
	}
	return $result;
	}

	function monitor_basket ($basket_contents) {
		//$tablec = $this->basket_tracking_sql->query_array("SELECT ".$this->basket_tracking_table." FROM information_schema.tables WHERE table_schema = '".$this->basket_tracking_sql->mySql_database."' AND table_name = '".$this->basket_tracking_table."';");
		$tablec = $this->basket_tracking_sql->query_array("show table status like '".$this->basket_tracking_table."'");
		if (count($tablec)==0) return false;
		if (empty($this->tixml_browser_id)) return false;
		$basket_history = $this->basket_tracking_sql->query_array("SELECT * FROM ".$this->basket_tracking_table." WHERE browser_id='".$this->tixml_browser_id."' AND basketid!=0 ORDER by id ASC");
		if (count($basket_history)==0) {
			$record = Array(
			"browser_id"=>$this->tixml_browser_id,
			"basketid"=>0,
			"itemname"=>"",
			"venue_id"=>0,
			"price"=>0,
			"syscharge"=>0,
			"event"=>"create"
		);
		$this->basket_tracking_sql->insert_array($this->basket_tracking_table, $record);
		//usleep(750000);
		}
		$last_basket = Array();
		foreach ($basket_history as $k=>$v) {
			$last_basket[$v['basketid']] = $v;
			if ($v['event']=="delete") unset($last_basket[$v['basketid']]);
		}
		$curr_basket = Array();
		foreach ($basket_contents['ITEMS'] as $k=>$v) {
			if ( !isset($last_basket[$v['BASKETID']]) ) {
				$record = Array(
					"browser_id"=>$this->tixml_browser_id,
					"basketid"=>$v['BASKETID'],
					"itemname"=>$v['ITEMNAME'],
					"venue_id"=>$v['VENUEID'],
					"price"=>$v['CALCPRICE'],
					"syscharge"=>$v['SYSCHARGEVALUE'],
					"event"=>"add"
				);
				$this->basket_tracking_sql->insert_array($this->basket_tracking_table, $record);
		} else if (isset($last_basket[$v['BASKETID']]) && $last_basket[$v['BASKETID']]['price']!==$v['CALCPRICE'] ) {
				$record = Array(
					"browser_id"=>$this->tixml_browser_id,
					"basketid"=>$v['BASKETID'],
					"itemname"=>$v['ITEMNAME'],
					"venue_id"=>$v['VENUEID'],
					"price"=>$v['CALCPRICE'],
					"syscharge"=>$v['SYSCHARGEVALUE'],
					"event"=>"modifiy"
				);
				$this->basket_tracking_sql->insert_array($this->basket_tracking_table, $record);
			}
		}
		foreach ($last_basket as $k=>$v) {
			if (array_subsearch($basket_contents['ITEMS'], $v['basketid'], "BASKETID")===false && !empty($v['basketid']) ) {
				$record = Array(
					"browser_id"=>$this->tixml_browser_id,
					"basketid"=>$v['basketid'],
					"itemname"=>$v['itemname'],
					"venue_id"=>$v['venue_id'],
					"price"=>$v['price'],
					"syscharge"=>$v['syscharge'],
					"event"=>"delete"
				);
				$this->basket_tracking_sql->insert_array($this->basket_tracking_table, $record);
			}
		}

	}
	function monitor_sale ($result, $buybasketcontent=false) {
		//sync
		if ( !isset($result['SYNCHANSWER'][0]) || $result['SYNCHANSWER'][0]=="true" || $buybasketcontent ) {
			$data = Array(
				"deliverymethod"=>$_SESSION['basket_deliverymethod'],
				"paymethod"=>$_SESSION['basket_paymethod']
			);
			$record = Array(
					"browser_id"=>$this->tixml_browser_id,
					"basketid"=>$result['TRANSACIONID'][0],
					"itemname"=>$result['ERRORMESSAGE'][0],
					"event"=>"start",
					"data"=>serialize($data)
				);
			if (strtolower($result['ISSUCCESS'][0])=="false") $record['event'] = "fail";
			if (strtolower($result['ISSUCCESS'][0])=="true" && $result['SYNCHANSWER'][0]=="true") $record['event'] = "sale";
		$this->basket_tracking_sql->insert_array($this->basket_tracking_table, $record);
	} else if (
			strtolower($result['SYNCHANSWER'][0])=="false" &&
			strtolower($result['LASTRESULT'][0])=="true"
		) {
		$record = Array(
					"browser_id"=>$this->tixml_browser_id,
					"basketid"=>$result['TRANSACIONID'][0],
					"itemname"=>$result['ERRORMESSAGE'][0],
					"event"=>"sale",
					"data"=>serialize($data)
				);
			if (strtolower($result['ISSUCCESS'][0])=="false") $record['event'] = "fail";
		$this->basket_tracking_sql->insert_array($this->basket_tracking_table, $record);
	}
	}

	function determineExtraCharge ($chargetext, $itemData) {
	preg_match_all('[([0-9\%]*)]', $chargetext, $matches, PREG_SET_ORDER);
	//print_r($matches);
	$baseprice = $itemData['CALCPRICE'];
	$extraamount = 0;
	foreach ($matches as $k=>$v)
	if (!empty($v)) {
		if (is_numeric($v[0])) $extraamount+=$v[0];
		else if (strpos($v[0], "%")!==false) $extraamount+=trim($v[0], "% ")/100*$baseprice;
	}
	if (file_exists("plugins/basket/extracharge.php")) include "plugins/basket/extracharge.php";
	return $extraamount;
	}

	function configfilepath ($type, $bind, $path="config/") {
	 $conf_file = $path.$type;
	 $conf_file .= $bind=="" ? "" : "_".$bind;
	 $conf_file .= (substr($conf_file, strlen($conf_file)-4)!==".php" ) ? ".php" : "";
	 return $conf_file;
	}

 function file_exists($file) {
		if(!file_exists($file)) {
				$paths=explode(PATH_SEPARATOR,get_include_path());
				foreach($paths as $p) if(file_exists(preg_replace('%/$%','',$p)."/$file")) return true;
				return false;
		} else return true;
 }

 function filesize($file) {
		if(!file_exists($file)) {
				$paths=explode(PATH_SEPARATOR,get_include_path());
				foreach($paths as $p) if(file_exists(preg_replace('%/$%','',$p)."/$file")) return filesize(preg_replace('%/$%','',$p)."/$file");
				return 0;
		} else return filesize($file);
 }
 function reindex_by_field ($target, $fieldname) {
	$result = Array();
	foreach ($target as $k=>$v) {
		if (isset($v[$fieldname])) $result[$v[$fieldname]] = $v;
		else $result[] = $v;
	}
	return $result;
 }

 function refresheventcache () {
	if ($this->basket_tracking_sql!=null && $this->basket_tracking_sql->connected==1) {
		$fieldset = $this->basket_tracking_sql->query_array("SHOW FULL COLUMNS FROM ".$this->event_cache_table);
		$fieldlist = Array();
		foreach ($fieldset as $k=>$v) {
			$fieldlist[$v['Field']] = $v['Field'];
		}
		$eventlist = $this->get_event_array(time(), 730, "", "0", "", "0", "", "0|5000");

		$sqlevents = Array();
		foreach ($eventlist as $k=>$v) {
			$actline = Array("region"=>$this->tixml_region_id);
			foreach ($fieldlist as $fn) {
				if (isset($v[$fn])) $actline[$fn] = $v[$fn];
			}
			$sqlevents[] = $actline;
		}
		foreach ($sqlevents as $k=>$v) {
			$this->basket_tracking_sql->delete($this->event_cache_table, Array("region"=>$this->tixml_region_id, "NETEVENT_ID"=>$v['NETEVENT_ID']) );
			$this->basket_tracking_sql->insert($this->event_cache_table, $v);
		}

		print_r($sqlevents);
		//$this->tixml_region_id
	}
 }

}

include_once("/var/www/clients/client65/web117/web/admin/modules/sync/interticket/include/class.cachemanager.php");
if (isset($GLOBALS['tixml_default_server'])) $GLOBALS['IT'] = new InterTicket();

?>