<?php

 /**
 * Logger Object for creating simple log files with auto size maximalization built in
 * @package InterTicket
 * @author Joseph Kizman - IntertTicket
 * @copyright 2008 Joseph Kizman - IntertTicket
 */
class Logger
{
 /**
  *  0 = false , 1 = true 
  *  @var int
  */  
 public $debug = 0;
 /**
  *  Maximum filesize in MegaBytes
  *  @var int
  */   
 public $maxlogsize = 10; // in MB
 /**
  *  Target output directory
  *  @var string
  */  
 public $logdir = "log/"; // relative
 /**
  *  Filename prefix ('log_' as default)
  *  @var string
  */
 public $prefix = "log_"; 

 /**
   * Main logging function for writing into log files
   * @param string $type Log type identifier
   * @param string $tolog Content to write
   * @param string $customdir Custom target directory path (Optional)
   * @return boolean Returns true on success and false on fail     
   */
 function log($type, $tolog, $customdir="") {
  $modifier = "";
  if (!file_exists(dirname(__FILE__)."/".$this->logdir)) mkdir(dirname(__FILE__)."/".$this->logdir, 0777, true);
  if (!file_exists(dirname(__FILE__)."/".$this->logdir.$customdir)) mkdir(dirname(__FILE__)."/".$this->logdir.$customdir, 0777, true);
  $targetdir = dirname(__FILE__)."/".$this->logdir.$customdir;
  $targetfile = $targetdir.$this->prefix.$type.$modifier.".log";
  while (file_exists($targetfile) && filesize($targetfile) >= $this->maxlogsize*1024*1024) {
   if ($modifier=="") $modifier = 1;
   $modifier++;
   $targetfile = dirname(__FILE__)."/".$this->logdir.$customdir.$this->prefix.$type.$modifier.".log";
  }
  $fp = fopen(dirname(__FILE__)."/".$this->logdir.$customdir.$this->prefix.$type.$modifier.".log","a");
  if ($fp) {
   $logdate = date("Y-m-d H:i:s");
   if ($this->debug == 1) echo "logging with time: '".$logdate."'<br>";
   $log_data = "
----- ".$logdate." -- ".$_SERVER['REQUEST_URI']." -----
$tolog
";
   fwrite($fp,$log_data);
   fclose($fp);
   return true;
  } else {
   return false;
  }
 }
 
  /**
   * Deletes a log file by the given parameters
   * @param string $type Log type identifier
   * @param string $customdir Custom target directory path (Optional) 
   * @return boolean Returns true on success and false on fail   
   */
 function del_log($type, $customdir="") {
  unlink (dirname(__FILE__)."/".$this->logdir.$customdir.$this->prefix.$type.".log");
  return !file_exists(dirname(__FILE__)."/".$this->logdir.$customdir.$this->prefix.$type.".log");
 }
 
};

$log = new Logger();

?>
