<?php

function subsort ($a, $b) {
 $result = (strcasecmp (trim($a[$GLOBALS['subsort_key']], "\" ' "), trim($b[$GLOBALS['subsort_key']], "\" ' ")));
 if (is_numeric($a[$GLOBALS['subsort_key']]) && is_numeric($b[$GLOBALS['subsort_key']])) {
  if ($a[$GLOBALS['subsort_key']]>$b[$GLOBALS['subsort_key']]) $result = 1;
  if ($b[$GLOBALS['subsort_key']]>$a[$GLOBALS['subsort_key']]) $result = -1;
  if ($a[$GLOBALS['subsort_key']]==$b[$GLOBALS['subsort_key']]) $result = 0;
 }
 if ($GLOBALS['subsort_desc']==true) return $result*-1;
 else return $result;
}

function array_subsort ($target, $subkey, $desc=false, $funcname='subsort'){
 $GLOBALS['subsort_key'] = $subkey;
 $GLOBALS['subsort_desc'] = $desc;
 //print_r($target);
 uasort ($target, $funcname);
 //print_r($target);
 return $target;
}

function array_custsort ($target, $funcname='strcmp_hun', $desc=false) {
 $GLOBALS['subsort_key'] = "";
 $GLOBALS['subsort_desc'] = $desc;
 uasort ($target, $funcname);
 return $target;
}
function array_custsort_key ($target, $funcname='strcmp_hun', $desc=false) {
 $GLOBALS['subsort_key'] = "";
 $GLOBALS['subsort_desc'] = $desc;
 uksort ($target, $funcname);
 return $target;
}

function strcmp_hun($s1, $s2) {
  $ssk = $GLOBALS['subsort_key'];
  //echo $s1.' '.$s2."<br>";
  if ($ssk=="") {
  	$s1 = mb_strtolower($s1, "UTF-8");
  	$s2 = mb_strtolower($s2, "UTF-8");  
  } else {
  	$s1 = mb_strtolower($s1[$ssk], "UTF-8");
  	$s2 = mb_strtolower($s2[$ssk], "UTF-8"); 
  }
  $s1=trim($s1);
  $s2=trim($s2);
  $magyarabc = " 0123456789aábcdeéfghiíjklmnoóöőpqrstuúüűvwxyz";
  $result = 0;
  $i = 0;
  $m = min(mb_strlen($s1), mb_strlen($s2));
  $p1 = mb_strpos($magyarabc, mb_substr($s1, $i, 1, "UTF-8"));
  $p2 = mb_strpos($magyarabc, mb_substr($s2, $i, 1, "UTF-8"));
  while ($p1==$p2 && $i<$m) {
  	$i++;
    $p1 = mb_strpos($magyarabc, mb_substr($s1, $i, 1, "UTF-8"));
    $p2 = mb_strpos($magyarabc, mb_substr($s2, $i, 1, "UTF-8"));
  }
  if ($p1>$p2) {
  	$result = 1;
  } else if ($p1<$p2) {
  	$result = -1;
  } else if ($p1==$p2) {
    if (strlen($s1)>strlen($s2)) {
     $result = 1;
    } else if (strlen($s1)<strlen($s2)) {
     $result = -1;
    }
  }
  if ($GLOBALS['subsort_desc']==true) return $result*-1;
  else return $result;
}

function strcmp_hun2($s1, $s2){  
	static $chr = array('á'=>'az','&aacute;'=>'az','&Aacute;'=>'az', 'é'=>'ez', '&eacute;'=>'ez' ,'&Eacute;'=>'ez' ,'í'=>'iz','&iacute;'=>'iz', '&Iacute;'=>'iz','ó'=>'oz','&oacute;'=>'oz','&Oacute;'=>'oz', 'ö'=>'oz','&ouml;'=>'oz','&#336;'=>'oz', 'ő'=>'oz', '&#337;'=>'oz','&#336;' =>'oz', 'ú'=>'uz','&uacute;'=>'uz', '&Uacute;'=>'uz','ü'=>'uz','&uuml;'=>'uz','&Uuml;'=>'uz', 'ű'=>'uz', '&#368;'=>'uz','&#369;'=>'uz','cs'=>'cz', 'zs'=>'zz', 'ccs'=>'czcz', 'ggy'=>'gzgz', 'lly'=>'lzlz', 'nny'=>'nznz', 'ssz'=>'szsz', 'tty'=>'tztz', 'zzs'=>'zzzz');    
	$result = strcmp(strtr(mb_strtolower($s1, "UTF-8"), $chr), strtr(mb_strtolower($s2, "UTF-8"), $chr));    
	if ($GLOBALS['subsort_desc']==true) return $result*-1;
	else return $result;
}

function configfilepath ($type, $bind, $path="config/") {
 $conf_file = $path.$type;
 $conf_file .= $bind=="" ? "" : "_".$bind;
 $conf_file .= (substr($conf_file, strlen($conf_file)-4)!==".php" ) ? ".php" : "";
 return $conf_file;
}

function saveconfig ($type, $bind, $target, $path="config/") {
 return ser_save ($type, $bind, $target, $path);
}

function restoreconfig ($type, $bind, $path="config/") {
 return ser_restore ($type, $bind, $path);
}

function ser_save ($type, $bind, $target, $path="config/") {
 if (!file_exists($path) && $path!=="") mkdir($path);
 $serialized = serialize($target);
 $conf_file = $path.$type;
 $conf_file .= $bind=="" ? "" : "_".$bind;
 $conf_file .= ".php";
 $conf = fopen($conf_file, "w");
 fwrite($conf, $serialized);
 fclose($conf);
 unset($serialized);
}

function ser_restore ($type, $bind, $path="config/") {
 $conf_file = $path.$type;
 $conf_file .= $bind=="" ? "" : "_".$bind;
 $conf_file .= (substr($conf_file, strlen($conf_file)-4)!==".php" ) ? ".php" : "";
 if (file_exists($conf_file)) { 
  $conf = fopen($conf_file, "r");
  $serialized = fread($conf, filesize($conf_file));
  fclose($conf);
  return unserialize($serialized);
  unset($serialized);
 } else {  
  return Array();
 }
}

function ser_move ($type, $bind, $path, $newtype, $newbind, $newpath="") {
 $conf_file = $path.$type;
 $conf_file .= $bind=="" ? "" : "_".$bind;
 $conf_file .= (substr($conf_file, strlen($conf_file)-4)!==".php" ) ? ".php" : "";
 if (file_exists($conf_file)) {
  $newconf_file = $newpath.$newtype;
  $newconf_file .= $newbind=="" ? "" : "_".$newbind;
  $newconf_file .= (substr($newconf_file, strlen($newconf_file)-4)!==".php" ) ? ".php" : "";
  rename($conf_file, $newconf_file);
  //unlink($conf_file);
 } else {
  return false;
 }
}

function ser_delete ($type, $bind, $path="config/") {
  $conf_file = $path.$type;
  $conf_file .= $bind=="" ? "" : "_".$bind;
  $conf_file .= (substr($conf_file, strlen($conf_file)-4)!==".php" ) ? ".php" : "";
  unlink($conf_file);
}

function get_language_arrayed () {
 $output = Array();
 include "lang_master.php";
 foreach ($languages_master as $actcategory=>$actvariables) {
  $output_actcategory = Array();
  foreach ($actvariables as $actvar=>$actvalue) {
   $output_actcategory[$actvar] = $_GLOBALS[$actvar];
  }
  $output[$actcategory] = $output_actcategory;
 }
 return $output;
}

function dump_language ($langcode, $writetofile=true) {
 if (is_array($langcode)) {
  $target_language = $langcode;
  $langcode = $langcode['Settings']['language_display_value'];
 } else {
  $target_language = $GLOBALS['languages_array'][$langcode];
 }
 $language_string = get_array_string($target_language, 1, 2);
 $language_string = '$languages_array[\''.$langcode.'\'] = '.$language_string.";";
 if ($writetofile==true) file_put_contents($GLOBALS['site_lang_dir']."/".$langcode.".lng", $language_string);
 return $language_string;
} 

function get_array_string ($target, $level=1, $newlines=1) {
 if ($newlines!==true && $newlines!==false) {
  $newline_m = $level<=$newlines ? true : false;
 } else {
  $newline_m = $newlines;
 }
 if ($newline_m==true) { 
  $newline = "
";
  $indrop = str_repeat(" ", $level);
 } else if ($newline_m==false) {
  $newline = "";
  $indrop = " ";
 }
 $output = "";
 foreach ($target as $actkey => $actvalue) {
  $output .= $output!=="" ? ",".$newline : "";
  if (is_array($actvalue)) {
   $output .= $indrop."\"".$actkey."\" => ".get_array_string ($actvalue, $level+1, $newlines);
  } else {
   $actvalue = str_replace('"', '\\"', $actvalue);
   $output .= $indrop."\"".$actkey."\" => \"".$actvalue."\"";
  } 
 }
 $indrop = substr($indrop, 0, strlen($indrop)-1);
 $output = "Array (".$newline.$output.$newline.$indrop.")";
 return $output;
}

function load_language ($langcode) {
 if (strpos($langcode, ".php")!==false || file_exists($GLOBALS['site_lang_dir']."/".$langcode.".php")) {
  if (strpos($langcode, ".php")==false) $langcode .= ".php";
  include $GLOBALS['site_lang_dir']."/".$langcode;
  include "flash_lang/".$langcode;
  $output = Array();
  include "lang_master.php";
  foreach ($languages_master as $actcategory=>$actvariables) {
   $output_actcategory = Array();
   foreach ($actvariables as $actvar=>$actvalue) {
    $output_actcategory[$actvar] = ${$actvar};
   }
   $output[$actcategory] = $output_actcategory;
  }
  dump_language($output);
  if (!file_exists($GLOBALS['site_lang_dir']."/backup")) mkdir($GLOBALS['site_lang_dir']."/backup", 0777);
  unlink($GLOBALS['site_lang_dir']."/backup/".$langcode);
  rename($GLOBALS['site_lang_dir']."/".$langcode, $GLOBALS['site_lang_dir']."/backup/".$langcode);
  $langcode = str_replace(".php", "", $langcode);
 }
 global $languages_array;
 if (strpos($langcode, ".lng")==false) $langcode .= ".lng";
 $langphp = file_get_contents($GLOBALS['site_lang_dir']."/".$langcode);
 if ($langphp!==false) {
  $langcode = str_replace(".lng", "", $langcode);
  unset($languages_array[$langcode]);
  $ev_suc = eval($langphp);
  if ($ev_suc===false) {
   //file_put_contents("a.dmg", $langphp);
   $langphp = false;
  }
 }
 return $langphp!==false;
}

function activate_language ($langcode) {
 global $languages_array;
 global $languages_master;
 foreach ($languages_array[$langcode] as $actcat => $actcatarr) {
  foreach ($actcatarr as $actkey=>$actvalue) {
   $GLOBALS[$actkey] = $actvalue; 
  }
 }
 foreach ($languages_master as $actcat => $actcatarr) {
  foreach ($actcatarr as $actkey=>$actvalue) {
   if ($actcat=="Admin" && ( !isset($GLOBALS[$actkey]) || $GLOBALS[$actkey]=="" ) ) {
    $GLOBALS[$actkey] = $actkey;
   }
  }
 }
 if (isset($GLOBALS[language_extra_fields])) {
  foreach ($GLOBALS[language_extra_fields] as $varname=>$varvalue) {
   $GLOBALS[$varname] = $varvalue;
  }
 }
}

function unactivate_language () {
 foreach ($GLOBALS as $actkey => $actvalue) {
  if (substr($actkey, 0, 9)=="language_" || substr($actkey, 0, 5)=="lang_") unset ($GLOBALS[$actkey]);
 }
}

function send_mail_auto ($from, $to, $subject, $message, $mail_encoding="UTF-8", $attachments="") {
 $ishtml = $message!==strip_tags($message) ? true : false;
 if ($ishtml==true) $message = nl2br($message);
 if (!isset($GLOBALS['site_conf_mail_smtp_server']) || $GLOBALS['site_conf_mail_smtp_server']=="" || !file_exists("PHPMailer/class.phpmailer.php")) {
  if ($ishtml==true) {
   $success = send_mail_html($from, $to, $subject, $message, $mail_encoding, $attachments);
  } else {
   $success = send_mail_text($from, $to, $subject, $message, $mail_encoding, $attachments);
  }
 } else {
  if ($mail_encoding!=="UTF-8") {
   $msg = mb_convert_encoding($message, $mail_encoding, "UTF-8");
   if ($msg!==FALSE) {
    $message = $msg;
    //$subject = iconv("UTF-8", $mail_encoding, $subject);
    $subject = mb_convert_encoding($subject, $mail_encoding, "UTF-8");
   }
   if ($msg===FALSE) $mail_encoding = "UTF-8";
  }
  $smtp_host = $GLOBALS['site_conf_mail_smtp_server'];
  $smtp_user = $GLOBALS['site_conf_mail_smtp_user'];
  $smtp_pass = $GLOBALS['site_conf_mail_smtp_pass'];
  $success = send_mail_smtp ($smtp_host, $smtp_user, $smtp_pass, $ishtml, $from, $to, $subject, $message, $mail_encoding, $attachments);
 }
 return $success;
}

function send_mail_html($from, $to, $subject, $message, $mail_encoding="UTF-8", $attachments="") {
 if ($mail_encoding=="") $mail_encoding="UTF-8";
 if ($mail_encoding!=="UTF-8") {
  $msg = mb_convert_encoding($message, $mail_encoding, "UTF-8");
  if ($msg!==FALSE) {
   $message = $msg;
   //$subject = iconv("UTF-8", $mail_encoding, $subject);
   $subject = mb_convert_encoding($subject, $mail_encoding, "UTF-8");
  }
  if ($msg===FALSE) $mail_encoding = "UTF-8";
 }
 if (!isset($GLOBALS['site_conf_mail_smtp_server']) || $GLOBALS['site_conf_mail_smtp_server']=="" || !file_exists("PHPMailer/class.phpmailer.php")) {
  $headers  = "MIME-Version: 1.0\n";
  $headers .= "Content-type: text/html; charset=".$mail_encoding."\n";
  $headers .= "From:".$from."\n";
  $headers .= "X-Sender: <".$from.">\n";
  $headers .= "X-Mailer: PHP\n"; 
  $headers .= "Return-Path:".$from."\n";
  $success = mail($to,$subject,$message,$headers);
 } else {
  $smtp_host = $GLOBALS['site_conf_mail_smtp_server'];
  $smtp_user = $GLOBALS['site_conf_mail_smtp_user'];
  $smtp_pass = $GLOBALS['site_conf_mail_smtp_pass'];
  $success = send_mail_smtp ($smtp_host, $smtp_user, $smtp_pass, true, $from, $to, $subject, $message, $mail_encoding, $attachments);
 }
 return $success;
}

function send_mail_text ($from, $to, $subject, $message, $mail_encoding="UTF-8", $attachments="") {
 if ($mail_encoding=="") $mail_encoding="UTF-8";
 if ($mail_encoding!=="UTF-8") {
  $msg = mb_convert_encoding($message, $mail_encoding, "UTF-8");
  if ($msg!==FALSE) {
   $message = $msg;
   //$subject = iconv("UTF-8", $mail_encoding, $subject);
   $subject = mb_convert_encoding($subject, $mail_encoding, "UTF-8");
  }
  if ($msg===FALSE) $mail_encoding = "UTF-8";
 }
 if (!isset($GLOBALS['site_conf_mail_smtp_server']) || $GLOBALS['site_conf_mail_smtp_server']=="" || !file_exists("PHPMailer/class.phpmailer.php")) {
  $headers  = "MIME-Version: 1.0\n";
  $headers .= "Content-type: text/plain; charset=".$mail_encoding."\n";
  $headers .= "From:".$from."\n";
  $headers .= "X-Sender: <".$from.">\n";
  $headers .= "X-Mailer: PHP\n"; 
  $headers .= "Return-Path: <".$from.">\n";
  $success = mail($to,$subject,$message,$headers);
 } else {
  $smtp_host = $GLOBALS['site_conf_mail_smtp_server'];
  $smtp_user = $GLOBALS['site_conf_mail_smtp_user'];
  $smtp_pass = $GLOBALS['site_conf_mail_smtp_pass'];
  $success = send_mail_smtp ($smtp_host, $smtp_user, $smtp_pass, false, $from, $to, $subject, $message, $mail_encoding, $attachments);
 }
 return $success;
}

function send_mail_smtp ($host, $smtp_user, $smtp_pass, $ishtml, $from, $to, $subject, $message, $mail_encoding="UTF-8", $attachments="") {
 require_once("PHPMailer/class.phpmailer.php");
 $mail = new PHPMailer();
 //$mail->SetLanguage("hu", "PHPMailer/language/");

 $mail->IsSMTP();               // set mailer to use SMTP
 if (substr_count($host, ":")>0) {
  $hostport = explode(":", $host);
  $mail->Port = $hostport[1];
  $host = $hostport[0];
 }
 $mail->Host = $host;           // specify main and backup server
 if ($smtp_user=="") {
  $mail->SMTPAuth = false;      // turn off SMTP authentication
 } else {
  $mail->SMTPAuth = true;       // turn on SMTP authentication
  $mail->Username = $smtp_user; // SMTP username
  $mail->Password = $smtp_pass; // SMTP password
 }
 $mail->From = $from;
 $mail->FromName = $from;
 $maildestinations = explode(",", $to);
 foreach ($maildestinations as $actdestination) {
  $mail->AddAddress($actdestination);   // recipient name optional
 }
 $mail->IsHTML($ishtml);                // set email format to HTML
 $mail->Subject = $subject;
 $mail->Body    = $message;
 $mail->CharSet = $mail_encoding;
 if ($attachments!=="") {
    $atms = explode(",", $attachments);
    foreach ($atms as $actfile) {
     //AddAttachment($path, $name = '', $encoding = 'base64', $type = 'application/octet-stream')
     if (substr($actfile, 0, 1)=="|") {
      $actfile = substr($actfile, 1);
      $mail->AddEmbeddedImage($actfile, $actfile);
     } else {
      $mail->AddAttachment($actfile, $actfile);
     }
    } 
 }
 $result = $mail->Send();
 if (!$result && isset($_GLOBALS['log'])) $_GLOBALS['log']->log("email-send-error", $to."\r\n".$mail->ErrorInfo);
 return $result;
}

function array_make_list($target, $keyword, $level=1) {
 $result = Array();
 foreach ($target as $line) {
  foreach ($line as $key => $value) {
   if ($key==$keyword && !in_array($value, $result)) $result[] = $value;
  }
 }
 $result2 = Array();
 if ($level>1) {
  foreach ($result as $key=>$value) {
   $result2[$key][$keyword] = $value;
  }
  $result = $result2;
 }
 return $result;
}

function load_site_configuration ($eredmeny=null) {
 if ($eredmeny==null) $eredmeny = ser_restore("sysconfig", "", "config/");
 if (count($eredmeny)==0) {
  include "config_master.php";
  $eredmeny = $configuration_master;
  ser_save("sysconfig", "", $eredmeny, "config/");
 }
 foreach ($eredmeny as $line) {
  if ($line['id']!==0) $GLOBALS[$line['variable']] = $line['value'];
 }
 return $eredmeny;
}

function update_site_configuration () {
 $currconfig = load_site_configuration ();
 include "config_master.php";
 $c = 0;
 $newconfig = Array();
 foreach ($configuration_master as $paramname=>$paramdata) {
  $keptparam = NULL;
  foreach ($currconfig as $currname=>$curritem) {
   if ($paramdata['variable']==$curritem['variable']) {
    $keptparam=$paramdata;
    $keptparam['value'] = $curritem['value'];
   }
  }
  if ($keptparam==NULL) {
   $keptparam = $paramdata;
   $c++;
  }
  $newconfig[$keptparam['variable']] = $keptparam;
 }
 ser_save("sysconfig", "", $newconfig, "config/");
 load_site_configuration ();
 return $c;
}

function multi_trim ($target, $trimstr) {
  $pattern = Array();
  for ($i=0; $i<strlen($trimstr); $i++) {
   $pattern[] = mb_substr($trimstr, $i, 1);
  }
  //$pattern = array('\'', '"', '-', ' ', '„');
  for ($i=0; $i<sizeof($pattern); $i++) {
   $target = mb_ereg_replace($pattern[$i], "", $target);
  }
  return $target;
}

function get_string_from_pattern ($actpattern) {
 $offset = 0;
  while (strpos($actpattern, '[_', $offset) !== false) {
   $lpos = strpos($actpattern, '[_', $offset);
   $varname = substr($actpattern, $lpos+2, strpos($actpattern, "_]", $lpos+3)-$lpos-2);
   $varvalue = (is_object($GLOBALS[$varname]) && get_class($GLOBALS[$varname])=="TemplateTool") ? $GLOBALS[$varname]->gettemplate() : $GLOBALS[$varname];
   $actpattern = str_replace('[_'.$varname."_]", $varvalue, $actpattern);
   //$this->applychange('{$'.$varname."}", $varvalue);
   $offset = $lpos+1;
  }
 $offset = 0;
  while (strpos($actpattern, '{$', $offset) !== false) {
   $lpos = strpos($actpattern, '{$', $offset);
   $varname = substr($actpattern, $lpos+2, strpos($actpattern, "}", $lpos+2)-$lpos-2);
   $varvalue = (is_object($GLOBALS[$varname]) && get_class($GLOBALS[$varname])=="TemplateTool") ? $GLOBALS[$varname]->gettemplate() : $GLOBALS[$varname];
   str_replace('{$'.$varname."}", $varvalue, $actpattern);
   //$this->applychange('{$'.$varname."}", $varvalue);
   $offset = $lpos+2;
  }
 return $actpattern;
}

function ftp_establish_connection ($server, $user, $pass) {
 // set up basic connection
 $conn_id = ftp_connect($server); 
 // login with username and password
 $login_result = ftp_login($conn_id, $user, $pass);
 // check connection
 if ((!$conn_id) || (!$login_result)) { 
  return false;
 } else {
  return $conn_id;
 } 
}

function ftp_is_dir($conn_id, $dir, $currdir="..") {
  if (ftp_chdir($conn_id, $dir)) {
    ftp_chdir($conn_id, $currdir);
    return true;
  } else {
    return false;
  }
}

$ftp_text_fileextensions = Array("php", "js", "vb", "tpl", "htm", "html", "xml", "css");

function ftp_download_file ($conn_id, $targetfile, $localtarget, $backupdir="", $forced_mode="") {
 $backupdir = $backupdir=="" ? "updater_backup/".date("Y")."-".date("m")."-".date("d")."_".date("H")."-".date("i")."-".date("m") : $backupdir;
 if (!file_exists($backupdir)) mkdir($backupdir);
 if (file_exists($localtarget)) rename($localtarget, $backupdir."/".$localtarget);
 //$backupdir."/".$localtarget
 $fileext = substr($targetfile, strrpos($targetfile, ".")+1);
 $ftp_mode = array_search($fileext, $GLOBALS['ftp_text_fileextensions'])===FALSE ? FTP_BINARY : FTP_ASCII;
 $ftp_mode = $forced_mode!=="" ? $forced_mode : $ftp_mode;
 ftp_get($conn_id, $localtarget, $targetfile, $ftp_mode);
 return file_exists($localtarget);
}

function ftp_download_dir_content_recursive ($conn_id, $targetdir, $localtarget="", $backupdir="", $root_path="/") {
 //echo "<br>Dir call: ".$targetdir." - ".$localtarget." - ".$backupdir;
 $backupdir = $backupdir=="" ? "updater_backup/".date("Y")."-".date("m")."-".date("d")."_".date("H")."-".date("i")."-".date("m") : $backupdir;
 if (!file_exists($backupdir)) create_dir_recursive($backupdir);
 $file_list = ftp_nlist ($conn_id, $targetdir."/");
 foreach ($file_list as $actfile) {
  $actfile = substr($actfile, strrpos($actfile, "/"));
  $actfile = trim($actfile, "/ ");
  //if (ftp_size ($conn_id, $targetdir."/".$actfile)!==-1) {
  if (!ftp_is_dir($conn_id, $targetdir."/".$actfile, $root_path)) {
   if (file_exists($localtarget.$actfile) && !is_dir($actfile)) rename($localtarget.$actfile, $backupdir."/".$actfile);
   $fileext = substr($actfile, strrpos($actfile, ".")+1);
   $ftp_mode = array_search($fileext, $GLOBALS['ftp_text_fileextensions'])===FALSE ? FTP_BINARY : FTP_ASCII;
   ftp_get($conn_id, $localtarget.$actfile, $targetdir.$actfile, FTP_BINARY);
  } else {
   if (!file_exists($localtarget.$actfile."/")) create_dir_recursive($localtarget.$actfile."/");
   ftp_download_dir_content_recursive($conn_id, $targetdir.$actfile."/", $localtarget.$actfile."/", $backupdir."/".$actfile, $root_path);
  }
 }
 return true;
}

function create_dir_recursive ($dirpath) {
 if (!file_exists($dirpath)) {
  if (strrpos($dirpath, "/")!==FALSE && !file_exists(substr($dirpath, 0, strrpos($dirpath, "/")))) create_dir_recursive(substr($dirpath, 0, strrpos($dirpath, "/")));
  mkdir ($dirpath);
 }
}

function create_array_from_string ($targetstring, $keyvalueseparator="|") {
  $resultarray = Array();
  $linelist_array = explode("
", $targetstring);
  foreach ($linelist_array as $actline) {
   if (strpos($actline, $keyvalueseparator)===FALSE) {
       $lineexploded[0]=$actline;
       $lineexploded[1]=$actline;
   } else {
       $lineexploded = explode($keyvalueseparator, $actline);
   }
   $resultarray[$lineexploded[0]] = $lineexploded[1];
  }
  return $resultarray;
}

function array_subsearch ($target, $value, $fieldname="") {
 $result = false;
 foreach ($target as $actkey=>$actvalue) {
  if ( ( ( in_array($value, $actvalue) && 
           ($fieldname=="" || $actvalue[$fieldname]==$value)
         ) 
         || ( $actvalue==$value
              && ($fieldname=="" || $actkey==$fieldname)
            )
       ) 
      && $result==false) {
	$result = $actkey;
  }
 }
 return $result;
}

function withcurrency($numtodo, $separator=" ") {
 if (!isset($GLOBALS['tixml_region_default_currency_after'])) $GLOBALS['tixml_region_default_currency_after'] = $GLOBALS['tixml_region_default_currency'];
 $numtodo = $GLOBALS['tixml_region_default_currency_before'].$separator.$numtodo.$separator.$GLOBALS['tixml_region_default_currency_after'];
 return $numtodo;
}

function getXmlArray ($xmldata, $encoding="UTF-8") {
 $xmlp = xml_parser_create($encoding);
 xml_parse_into_struct($xmlp, $xmldata, $vals, $index);
 xml_parser_free($xmlp);
 $output = parseXmlArray($vals);
 return $output;
}

function parseXmlArray($tagitems) {
 $output = Array();
 $i=0;
 while ($i<count($tagitems)) {
  if ($tagitems[$i]['type']=="open") {
   $closerfound = $i;
   for ($j=$i+1;$j<=count($tagitems);$j++) {
    if ($closerfound==$i && 
        $tagitems[$j]['type']=="close" && 
        $tagitems[$j]['tag']==$tagitems[$i]['tag'] && 
        $tagitems[$j]['level']==$tagitems[$i]['level'] ) $closerfound = $j;
   }
   $newtagitems = Array();
   for ($j=$i+1;$j<$closerfound;$j++) {
    $newtagitems[] = $tagitems[$j];
   }
   $subarray = parseXmlArray($newtagitems);
   if (isset($output[$tagitems[$i]['tag']][0])) {
    $output[$tagitems[$i]['tag']][] = $subarray;
   } else if ( isset($output[$tagitems[$i]['tag']]) ) {
    $temp = $output[$tagitems[$i]['tag']];
    unset($output[$tagitems[$i]['tag']]);
    $output[$tagitems[$i]['tag']] = Array();
    $output[$tagitems[$i]['tag']][] = $temp;
    $output[$tagitems[$i]['tag']][] = $subarray;
   } else {
    $output[$tagitems[$i]['tag']] = $subarray;
   }
   if (isset($tagitems[$i]['attributes'])) {
    foreach ($tagitems[$i]['attributes'] as $attrname=>$currattr) {
     $output[$tagitems[$i]['tag']][$attrname] = $currattr;
    } 
   }
   $i = $closerfound;
  } else if ($tagitems[$i]['type']=="complete") {
   $output[$tagitems[$i]['tag']] = $tagitems[$i]['value'];
  }
  $i++;
 }
 return $output;
}



function ArrayToXml ($target, $level=0) {
 $output = "";
 $leveltext = "";
 for ($i=0;$i<$level;$i++) {
  $leveltext.=" ";
 }
 foreach ($target as $actkey=>$actvalue) {
  if (is_array($actvalue)) {
   $output .= $leveltext."<".$actkey.">
".ArrayToXml($actvalue, $level+1).$leveltext."</".$actkey.">
";
  } else {
   $output .= $leveltext."<".$actkey.">".CDATAifneeded($actvalue)."</".$actkey.">
";
  } 
 }
 return $output;
}

function CDATAifneeded ($target) {
 $target_chars = "#&<>/";
 $needed = false;
 for ($i=0;$i<strlen($target_chars);$i++) {
  $actchar = substr($target_chars, $i, 1);
  if ($needed==false && strpos($target, $actchar)!==false) {
   $needed = true;
  }
 }
 if ($needed==true) {
  $target = "<![CDATA[".$target."]]>";
 }
 return $target;
}

function converttoutf8 ($target) {
 $currenc = mb_detect_encoding($target, "ISO-8859-1, ISO-8859-2, UTF-8");
 $target = mb_convert_encoding($target, "UTF-8", $currenc);
 return $target;
}

function openinbackground ($targeturl, $timeout=1) {
  ob_start();
  $ch = curl_init($targeturl);
  curl_setopt($ch, CURLOPT_PORT, 80);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, true);
  curl_setopt($ch, CURLOPT_VERBOSE, false);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 0);
  curl_setopt($ch, CURLOPT_POST, 0);
  curl_setopt($ch, CURLOPT_TIMEOUT, 2000000);
  $result = curl_exec($ch);
  ob_end_clean();
}

function getnamebyformat ($format, $firstname, $lastname) {
  $format = str_replace("last", $lastname, $format);
  $format = str_replace("first", $firstname, $format);
  return $format;
}
//html_gen_link ($target, $name, $window="", $class="", $var="", $value="") {
function geteventlink ($eventdata, $linktext="", $linkclass="") {
   if ($eventdata['NETWORKAVAILABLE']=="false") {
    if (isset($eventdata['NETAVAILTEXTBEFORE']) && $eventdata['NETAVAILTEXTBEFORE']!=="") {
     $eventlink = $eventdata['NETAVAILTEXTBEFORE'];
    } else {
     $eventlink = $GLOBALS['lang_not_available'];
    }
   } else if (strtolower($eventdata['TICKETAVAIL'])=="false") {
    $linktext = $linktext=="" ? $GLOBALS['lang_sold_out'] : $linktext." (".$GLOBALS['lang_sold_out'].")";
    $eventlink = $linktext;
   } else if (strtolower($eventdata['EVENTSTATUS_ID'])=="3") {
    $linktext = $linktext=="" ? $GLOBALS['lang_search_cancelled'] : $linktext." (".$GLOBALS['lang_search_cancelled'].")";  
    $eventlink = $linktext;
   } else if (($eventdata['ARRIVALORDER'] == "true" || $eventdata['ENABLEDAUDITVIEWMETHODS']==0) && $GLOBALS['site_search_best_seat_enabled']=="1") {
    $linktext = $linktext=="" ? "<b>".$GLOBALS['lang_buy_best_tickets']."</b>" : $linktext;
    $eventlink = "arrivalorder.php?eid=".$eventdata['NETEVENT_ID']."&aid=".$eventdata['NETAUDIT_ID']."&vid=".$eventdata['VENUE_ID'].$GLOBALS['extravars'];
    $eventlink = html_gen_link($eventlink, $linktext, "", $linkclass);
   } else if (($eventdata['ARRIVALORDER'] == "false") && $GLOBALS['site_search_audiwiev_enabled']=="1") {
   //|| $eventdata['ENABLEDAUDITVIEWMETHODS']!==0
    $linktext = $linktext=="" ? "<b>".$GLOBALS['lang_buy_tickets']."</b>" : $linktext;
    $eventlink = "auditwiev.php?eid=".$eventdata['NETEVENT_ID']."&aid=".$eventdata['NETAUDIT_ID']."&vid=".$eventdata['VENUE_ID'].$GLOBALS['extravars'];
    $eventlink = html_gen_link($eventlink, $linktext, "", $linkclass);
   } else if ($GLOBALS['site_search_reservation_enabled']==1) {
    $linktext = $linktext=="" ? "<b>".$GLOBALS['lang_reserve_seats']."</b>" : $linktext;
    $eventlink = "reservation.php?eid=".$eventdata['NETEVENT_ID']."&aid=".$eventdata['NETAUDIT_ID']."&vid=".$eventdata['VENUE_ID'].$GLOBALS['extravars'];                    
    $eventlink = html_gen_link($eventlink, $linktext, "", $linkclass);
   } else {
    $linktext = $linktext=="" ? "<b>".$GLOBALS['lang_buy_best_tickets']."</b>" : $linktext;
    $eventlink = "arrivalorder.php?eid=".$eventdata['NETEVENT_ID']."&aid=".$eventdata['NETAUDIT_ID']."&vid=".$eventdata['VENUE_ID'].$GLOBALS['extravars'];
    $eventlink = html_gen_link($eventlink, $linktext, "", $linkclass);
   }
   return $eventlink;
}

function get_basket_information ($basketarray=false) {
	if ($basketarray==false) {
		$basketarray = $GLOBALS['IT']->get_basket_array();
	}
	$GLOBALS['basket_array'] = $basketarray;
	if ($basketarray['ITEMS']>0 && !isset($_SESSION['basket_start'])) {
	 $_SESSION['basket_start'] = time();
	} else if (count($basketarray['ITEMS'])==0 || !isset($basketarray['ITEMS'])) {
	 unset($_SESSION['basket_start']);
	}
	//print_r($basketarray);
	//importing Global variables
	global $site_basket_pdf_on, $site_basket_voucher_on, $site_basket_mailout_on, $site_basket_sys_courier_on, $site_basket_courier_on, $site_basket_pdf_or_voucher;
	global $site_pay_creditcard_enabled, $lang_pay_cash_enabled, $site_pay_abaqoos_enabled, $site_pay_cmps_enabled, $site_paypal_express_checkout_enabled;
	global $site_pay_cmps_lower_limit, $site_pay_cmps_upper_limit, $site_pay_cmps_upper_limit_pannon, $site_pay_cmps_item_limit, $site_pay_cmps_upper_item_limit, $site_pay_cmps_lower_item_limit, $site_pay_cmps_outer_tariff;
	global $tixml_region_ticket_extra_charge;
	//defining defaults
	$pdf_enabled = true;
	$netprint_enabled = true;
    $homogen_basket = true;
    $basket_deliverycharge = 0;
	$basket_netprice = 0;
	$itemprice_max = 0;
	foreach ($basketarray['ITEMS'] as $actk=>$actitem) {
		if ($actitem['PDFPRINTENABLED']=="false" && $pdf_enabled==true) $pdf_enabled=false;
		if ($basketarray['ITEMS'][0]['PDFPRINTENABLED']!==$actitem['PDFPRINTENABLED'] && $homogen_basket==true) $homogen_basket = false;
		if ($actitem['NETTICKETPRINTENABLED']=="false" && $netprint_enabled==true) $netprint_enabled=false;
		if ($tixml_region_ticket_extra_charge!=="" && $tixml_region_ticket_extra_charge!=="0") $actitem['SYSCHARGEVALUE'] += $tixml_region_ticket_extra_charge;
		$itemprice = str_replace(",", ".", $actitem['CALCPRICE'])+str_replace(",", ".", $actitem['SYSCHARGEVALUE']);
		$itemprice_max = max($itemprice_max, $itemprice);
		$itemprice_min = !isset($itemprice_min) ? $itemprice : min($itemprice_min, $itemprice);
		$basketarray['ITEMS'][$actk]['SUMPRICE'] = $itemprice;
		$basket_netprice += $itemprice;
	}
	if ($basketarray['TRANSCHARGEVALUE'][0]>0) $basket_netprice += $basketarray['TRANSCHARGEVALUE'][0];
    $shipping_charge = $GLOBALS['IT']->get_shipping_charge_array();
	if ($_SESSION['basket_deliverymethod']=="SYSCOURIER" && $basket_netprice!==0) $basket_deliverycharge = $shipping_charge['SHIPPINGCHARGE'];
	$basket_netprice += $basket_deliverycharge;
	//setting output values
	$basket_properties = Array();
	$basket_properties['basket'] = $basketarray;
	$basket_properties['deliverymethods'] = Array();
	$basket_properties['deliverymethods_enabled'] = Array();
	$basket_properties['paymentmethods'] = Array();
	$basket_properties['paymentmethods_enabled'] = Array();
	$basket_properties['deliverycharge_amount'] = $shipping_charge['SHIPPINGCHARGE'];
	$basket_properties['deliverycharge'] = $basket_deliverycharge;
	$basket_properties['transcharge'] = $basketarray['TRANSCHARGEVALUE'][0];
	$basket_properties['basket_netprice'] = $basket_netprice;
	$basket_properties['basket_itemcount'] = count($basketarray['ITEMS']);
	$basket_properties['homogen_basket'] = $homogen_basket;
	$basket_properties['pdf_enabled'] = $pdf_enabled;
	$basket_properties['netprint_enabled'] = $netprint_enabled;
	//adding delivery methods
	 if ($site_basket_pdf_on=="1") $basket_properties['deliverymethods'][] = "PDF";
	 if ($site_basket_voucher_on=="1") $basket_properties['deliverymethods'][] = "VOUCHER";
	 if ($site_basket_mailout_on=="1") $basket_properties['deliverymethods'][] = "MAILOUT";
	 if ($site_basket_sys_courier_on=="1") $basket_properties['deliverymethods'][] = "SYSCOURIER";
	 if ($site_basket_courier_on=="1") $basket_properties['deliverymethods'][] = "COURIER";
	 //PDF
	 if ($site_basket_pdf_on=="1" && $pdf_enabled && $homogen_basket) $basket_properties['deliverymethods_enabled'][] = "PDF";
     //Voucher
     if ($site_basket_voucher_on=="1" && $homogen_basket && 
         (
	      !isset($site_basket_pdf_or_voucher) || 
          $site_basket_pdf_or_voucher=="0" || 
          $pdf_enabled==false
         )
        ) {
			$basket_properties['deliverymethods_enabled'][] = "VOUCHER";
     }
     if ($site_basket_mailout_on=="1") $basket_properties['deliverymethods_enabled'][] = "MAILOUT";
     //GLS
     $basket_properties['shipping_data'] = $shipping_charge;
     if ($site_basket_sys_courier_on=="1" && $netprint_enabled && $shipping_charge['SHIPPINGDURATIONVALID']=="true") $basket_properties['deliverymethods_enabled'][] = "SYSCOURIER";
     //Courier
     if ($site_basket_courier_on=="1") $basket_properties['deliverymethods_enabled'][] = "COURIER";
     //adding payment methods
     if ($site_pay_creditcard_enabled=="1") $basket_properties['paymentmethods'][] = "CCARD";
	 if ($site_pay_cmps_enabled=="1") $basket_properties['paymentmethods'][] = "CMPS";
	 if ($site_pay_abaqoos_enabled=="1") $basket_properties['paymentmethods'][] = "ABAQOOS";
	 if ($site_paypal_express_checkout_enabled=="1") $basket_properties['paymentmethods'][] = "PAYPALEC";
	 if ($lang_pay_cash_enabled=="1") $basket_properties['paymentmethods'][] = "CASH";
	 //setting enabled payment methods
	 if ($site_pay_creditcard_enabled=="1") $basket_properties['paymentmethods_enabled'][] = "CCARD";
	 if ($site_paypal_express_checkout_enabled=="1") $basket_properties['paymentmethods_enabled'][] = "PAYPALEC";
	 	 	 
	 if ($site_pay_cmps_enabled=="1" && 
		 $itemprice_min>$site_pay_cmps_lower_limit && $itemprice_max<$site_pay_cmps_upper_limit &&
		 $basket_properties['basket_netprice']>=$site_pay_cmps_lower_item_limit && $basket_properties['basket_netprice']<=$site_pay_cmps_upper_item_limit && 
		 ( $site_pay_cmps_item_limit=="0" || $site_pay_cmps_item_limit>=$basket_properties['basket_itemcount'] )
		) {
		 $basket_properties['paymentmethods_enabled'][] = "CMPS";
	 }
	 if ($site_pay_abaqoos_enabled=="1") $basket_properties['paymentmethods_enabled'][] = "ABAQOOS";
	 if ($lang_pay_cash_enabled=="1") $basket_properties['paymentmethods_enabled'][] = "CASH";
	 //print_r($basket_properties);
	 return $basket_properties;
}

function lastpages_push ($itemname, $itemurl) {
	if (!isset($_SESSION['sess_last_visited'])) $_SESSION['sess_last_visited']=Array();
	if (array_subsearch($_SESSION['sess_last_visited'], $itemname, "name")!==false) {
		$foundpos = array_subsearch($_SESSION['sess_last_visited'], $itemname, "name");
		unset($_SESSION['sess_last_visited'][$foundpos]);
	}
	if ($itemname!=='' && $itemurl!=='') {
		$lv_actpage_item = Array("name"=>$itemname, "url"=>$itemurl);
		array_unshift($_SESSION['sess_last_visited'], $lv_actpage_item);
	}
}

function dump_to_js ($array, $name) {
	$output = $name." = new Array();\n";
	foreach ($array as $actname=>$actitem) {
		if (is_array($actitem)) {
			$output .= dump_to_js($actitem, $name."['".$actname."']");
		} else {
			$output .= $name."['".$actname."'] = '".$actitem."';\n";
		}
	}
	return $output;
}

function checkconditions ($rate, $item, $basketinfo) {
	if (isset($rate['RCOND'])) {
	 $cond = $rate['RCOND'];
	} else {
	 $cond = $rate;
	}
	$result = true;
	foreach ($cond as $actcondkey=>$actcond) {
		$ct = $actcond['TYPE'];
		if ($result==true) {
			$itemprice = $item['PRICE'];
			if ($ct==1 && strpos(strtolower($item['ITEMNAME']), strtolower($actcond['VALUE']))===false) {
				$result = false;
			} else if ($ct==2 && $itemprice!==$actcond['VALUE']) {
				$result = false;
			} else if ($ct==3 && $itemprice>=$actcond['VALUE']) {
				$result = false;
			} else if ($ct==4 && $itemprice<=$actcond['VALUE']) {
				$result = false;
			} else if ($ct==5 && $basketinfo['basket_itemcount']<$actcond['VALUE']) {
				$result = false;
			} else if ($ct==6 && $basketinfo['basket_netprice']<$actcond['VALUE']) {
				$result = false;
			} else if ($ct==7 && strtolower($_SESSION['sess_region'])!==strtolower($actcond['VALUE'])) {
				$result = false;
			} else if ($ct==8 && (!isset($_SESSION['member_login']) || $_SESSION['member_login']=="")) {
				$result = false;
			} else if ($ct==9 && (!isset($_SESSION['reg_'.$_SESSION['sess_region']]['sess_client_email']) || $_SESSION['reg_'.$_SESSION['sess_region']]['sess_client_email']=="")) {
				$result = false;
			} else if ($ct==10) {
				$tmp = false;
				foreach ($basketinfo['basket']['ITEMS'] as $actitem) {
					if ($tmp==false && strpos(strtolower($actitem['ITEMNAME']), strtolower($actcond['VALUE']))!==false) $tmp=true;
				}
				$result = $tmp;
			} else if ($ct==11 && isset($GLOBALS['rateapplies'][$rate['RID']]) && $GLOBALS['rateapplies'][$rate['RID']]>=$actcond['VALUE']) {
				$result = false;
			} else if ($ct==12) {
				$tindex = Array();
				foreach ($cond as $ack=>$ac) {
					if ($ac['TYPE']==10) {
						$tmp_cond = Array($ac);
						$tmp_cond[0]['TYPE'] = 1;
						foreach ($basketinfo['basket']['ITEMS'] as $actitem) {
							$tmp_item = $actitem;
							if (!isset($tindex[$ack])) $tindex[$ack]=0;
							if (checkconditions($tmp_cond, $tmp_item)) $tindex[$ack]++;
						}
					}
				}
				$packnum = null;
				foreach ($cond as $ack=>$ac) {
					if ($ac['TYPE']==10) {
						if ($packnum==null) $packnum = $tindex[$ack];
						$packnum = min($tindex[$ack], $packnum);
					}
				}
				//print_r($tindex);
				if (isset($GLOBALS['rateapplies'][$rate['RID']."_".$rate['RNAME']]) && $GLOBALS['rateapplies'][$rate['RID']."_".$rate['RNAME']]>=$packnum) {
					$result = false;
				}
				if (!isset($twelve)) $twelve = true;
				//echo $rate['RID']."_".$actcondkey;
			}
			//if (!$result) echo $ct;
		}
		//$actcond['VALUE']
	}
	if ($result==true && $twelve==true) $GLOBALS['rateapplies'][$rate['RID']."_".$rate['RNAME']] = !isset($GLOBALS['rateapplies'][$rate['RID']."_".$rate['RNAME']]) ? 1 : $GLOBALS['rateapplies'][$rate['RID']."_".$rate['RNAME']]+1;
	if ($result==true) $GLOBALS['rateapplies'][$rate['RID']] = !isset($GLOBALS['rateapplies'][$rate['RID']]) ? 1 : $GLOBALS['rateapplies'][$rate['RID']]+1;
	return $result;
}

?>