<?php

    function dump($var, $print = true) {
    	echo '<pre style="background: #ddd; border: 1px solid black; margin: 5px; text-align: left; padding: 10px; color: #000;">';
    	$print ? print_r( $var ) : var_dump( $var );
    	echo '</pre>';
    }
    
    
    function showEvents($aEvents)
	{
	    $o = '';
	    foreach ($aEvents as $event) {
	        $o.= "<div class=\"event medium\">\n";
            if (isset($event['image_med'])) {
                $o.= "<a href=\"".$event['url']."\" title=\"Night of the Jumps\"><img src=\"".$event['image_med']."\" alt=\"".$event['event_name']."\" /></a>\n";
            }
            $o.= "<a href=\"".$event['url']."\" class=\"title\" title=\"".$event['event_name']."\">".$event['event_name']."</a><p>".$event['date_from']." - ".$event['date_to']."<br />".$event['venue_town']."<br />".$event['venue_iso2_country_code']."</p>\n";
            $o.= "<a href=\"".SELF."?eid=".$event['event_id']."\" class=\"buy\" title=\"Tickets\">Tickets</a>\n";
            $o.= "</div>\n";
            $o.= "<hr />\n";
	    }
	    
	    return $o;
	}
	
	function showPerformances($aEvents)
	{
	    $o = '';
	    foreach ($aEvents as $event) {
	        $o.= '<div id="content" class="first">'."\n";
            $o.= '  <h2>'.$event['event_name'].'</h2>'."\n";
            $o.= '  <div id="events" class="clearfix">'."\n";
            $o.= '    <div class="event big">'."\n";
            if (isset($event['image_big'])) {
                $o.= '      <img src="'.$event['image_big'].'" alt="'.$event['event_name'].'" />'."\n";
            }
            $o.= '      <h4 class="title">Venue:</h4>'."\n";
            $o.= '      <p>'.$event['venue_name'].'<br />'.$event['venue_street'].', '.$event['venue_town'].'<br />'.$event['venue_iso2_country_code'].'</p>'."\n";
            $o.= '    </div>'."\n";
            $o.= '    <div class="event small delimiter">'."\n";
            $o.= '      <h4 class="title">Performances:</h4>'."\n";
            $o.= '    </div>'."\n";
            foreach ($event['performances'] as $p) {
	            $o.= '    <div class="event small">'."\n";
                $o.= '      <a href="'.$p['url'].'" class="title" title="'.$p['performance_name'].'">'.$p['performance_name'].'</a>'."\n";
                $o.= '      <a href="'.$p['url'].'" class="buy" title="Tickets">Tickets</a>'."\n";
                $o.= '      <p>'.$p['date_sales_to'].'</p>'."\n"; 
                $o.= '    </div>'."\n";
	        }
            $o.= '    <div class="event small delimiter">'."\n";
            $o.= '      <h4>Info</h4>'."\n";
            $o.= '    </div>'."\n";
            $o.= '    <div id="event_details">'."\n";
            $o.= '      <p>'.$event['desc_local'].'</p>'."\n";
            $o.= '    </div>'."\n";
            $o.= '</div>'."\n";
	    }
	    
	    return $o;
	    
	}
	
	function formSearch($aData,$cSessionId) {
	    $o = "<form method=\"post\" id=\"wssearch\" action=\"".SELF."\">\n";
    	$o.= "<div>\n";
    	$o.= "<input type=\"hidden\" name=\"sid\" value=\"".$cSessionId."\" />\n";
    	$o.= "<input type=\"hidden\" name=\"submits\" value=\"1\" />\n";
    	$o.= "</div>\n";
    	
        $o.= "<table>\n";
        $o.= "  <tr>\n";
        $o.= "    <td>Event title</td>\n";
        $o.= "    <td><input type=\"text\" name=\"event_name\" value=\"".$aData['event_name']."\" /></td>\n";
        $o.= "  </tr>\n";
        
        $o.= "  <tr>\n";
        $o.= "    <td>Date from</td>\n";
        $o.= "    <td>\n";
        $o.= "    <select name=\"date_from_y\">\n";
        $o.= "      <option value=\"\">year</option>\n";
        $o.= selectNum(1985,2008,$aData['date_from_y']);
        $o.= "    </select>\n";
        $o.= "    <select name=\"date_from_m\">\n";
        $o.= "      <option value=\"\">month</option>\n";
        $o.= selectNum(1,12,$aData['date_from_m']);
        $o.= "    </select>\n";
        $o.= "    <select name=\"date_from_d\">\n";
        $o.= "      <option value=\"\">day</option>\n";
        $o.= selectNum(1,31,$aData['date_from_d']);
        $o.= "    </select>\n";
        $o.= "    </td>\n";
        $o.= "  </tr>\n";
        
        $o.= "  <tr>\n";
        $o.= "    <td>Date to</td>\n";
        $o.= "    <td>\n";
        $o.= "    <select name=\"date_to_y\">\n";
        $o.= "      <option value=\"\">year</option>\n";
        $o.= selectNum(1985,2008,$aData['date_to_y']);
        $o.= "    </select>\n";
        $o.= "    <select name=\"date_to_m\">\n";
        $o.= "      <option value=\"\">month</option>\n";
        $o.= selectNum(1,12,$aData['date_to_m']);
        $o.= "    </select>\n";
        $o.= "    <select name=\"date_to_d\">\n";
        $o.= "      <option value=\"\">day</option>\n";
        $o.= selectNum(1,31,$aData['date_to_d']);
        $o.= "    </select>\n";
        $o.= "    </td>\n";
        $o.= "  </tr>\n";
        
        $o.= "  <tr>\n";
        $o.= "    <td>City</td>\n";
        $o.= "    <td><input type=\"text\" name=\"city\" value=\"".$aData['city']."\" /></td>\n";
        $o.= "  </tr>\n";
        
        $o.= "  <tr>\n";
        $o.= "    <td>Venue</td>\n";
        $o.= "    <td><input type=\"text\" name=\"venue\" value=\"".$aData['venue']."\" /></td>\n";
        $o.= "  </tr>\n";
        
        $o.= "  <tr>\n";
        $o.= "    <td>Category</td>\n";
        $o.= "    <td><input type=\"text\" name=\"category\" value=\"".$aData['category']."\" /></td>\n";
        $o.= "  </tr>\n";
        
        $o.= "  <tr>\n";
        $o.= "    <td>Country ISO2</td>\n";
        $o.= "    <td><input type=\"text\" name=\"country_iso2\" value=\"".$aData['country_iso2']."\" /></td>\n";
        $o.= "  </tr>\n";
        $o.= "  <tr>\n";
        $o.= "    <td>&nbsp;</td>\n";
        $o.= "    <td><input type=\"submit\" value=\"Search\" /></td>\n";
        $o.= "  </tr>\n";
        $o.= "</table>\n";
        $o.= "</form>\n";
        
        return $o;
	}
	
	function selectNum($nStart,$nEnd,$nCurrent) {
	    $o = '';
	    
	    for ($i=$nStart; $i<=$nEnd; $i++) {
	        $cS = ($i==$nCurrent) ? ' selected="selected"' : '';
	        $o.= "<option value=\"".$i."\"".$cS.">".$i."</option>\n";
	    }
	    
	    return $o;
	}
	
	
	function condate($cDate,$nType)
    {
        switch ($nType) {
        case 1:
            $aDate = explode(' ',$cDate);
            $aDay = explode('.',$aDate[0]);
            $aHour = explode(':',$aDate[1]);
            return mktime($aHour[0],$aHour[1],$aHour[2],$aDay[1],$aDay[0],$aDay[2]);
            break;
        }
            
            
    }

?>