<?php
error_reporting(E_ALL); 
ini_set('error_reporting', E_ALL);
require_once 'SOAP/Client.php';

define('PID','2667');
define('USERNAME','stremgabor');
define('PASSWORD','Stem389');

/**
 *
 * 
 *
 * @return array / string
 */
class WSPartner
{
    /**
     * @param string partner session id
     */
    var $cSessId;
    
    /**
     * @param int   partner id
     */
    var $nPid;
    
    /**
     * @param string partner username
     */
    var $cUsername;
    
    /**
     * @param string partner password
     */
    var $cPassword;
    
    /**
     * @param object webservice object
     */
    var $_ws;
    
    /**
     * @param bool data submitet is empty
     */
    var $bDataEmpty;
    
    /**
     * @param bool data erorr
     */
    var $bDataError;
    
    /**
     * @param array data validation
     */
    var $_arr;
    
    /**
     * connect to WS
     * @param $cSessId string partner ws session id
     * 
     * set _ws object (webservice object)
     * set cSessId
     */
    function WSPartner($cSessId = '')
    {
        // _______________________________________________________________
    
    	// WebServices Partner URL
    	$wsdl = new SOAP_WSDL('http://195.246.8.133/p_client_dev1/p_client.asmx?WSDL');
    	$oWs  = $wsdl->getProxy();
    	
    	$this->cSessId = isset($cSessId) ? $cSessId : '';
    	
    	$this->_ws = $oWs;
    	$this->setPartner();
    	
    	$this->_arr['string'] = array('event_name','city','venue','country_iso2');
        $this->_arr['num']    = array('category','eid','date_from_y','date_from_m','date_from_d','date_to_y','date_to_m','date_to_d');
    }
    
    
    /**
     * search for events
     * @param $aData array data submited trought search
     * 
     * @return event array or error string
     */
    function getEvent($aData,$nEventId = -1)
    {
        if ($nEventId > 0) {
            $this->validate($this->_arr);
            $this->aData['eid'] = $nEventId;
        } else {
            $this->validate($this->_arr);
            
            if ($this->bDataError === true) {
                return 'Data error';
            }
            
            if ($this->bDataEmpty === true) {
                return 'Data empty';
            }
        }
            
        
        $oSearch = $this->_ws->p_search($this->cSessId,$this->aData['event_name'],
                                        $this->aData['date_from'],$this->aData['date_to'],
                                        $this->aData['city'],$this->aData['venue'],
                                        $this->aData['category'],$this->aData['country_iso2'],
                                        $this->aData['eid']);
        $nErrorId = -1;
        if (isset($oSearch->system->system_msg_no)) {
            $nErrorId = $oSearch->system->system_msg_no;
        }
        
        switch ($nErrorId) {
        // login failed
        case 1:
            $oLogin = $this->_ws->p_login($this->nPid,$this->cUsername,
                                          $this->cPassword);
            if (isset($oLogin->session_id)) {
                // set partner session id
                $this->cSessId = $oLogin->session_id;
                
                // return list of events
        	    return $this->getEvent($aData);
            } else {
                return 'Login failed';
            }
            break;
        
        //
        case 2:
            return 'DB error';
            break;
        
        // wrong session id
        case 3:
            $oLogin = $this->_ws->p_login($this->nPid,$this->cUsername,
                                          $this->cPassword);
            if (isset($oLogin->session_id)) {
                // set partner session id
                $this->cSessId = $oLogin->session_id;
                
                // return list of events
        	    return $this->getEvent($aData,$nEventId);
            } else {
                return 'Wrong session ID';
            }
            break;
        
        //
        case 4:
            return 'No records found';
            break;
        
        // print events
        default:
            $arr = object_to_array($oSearch->event);
            if (array_key_exists('event_name',$arr)) {
                $arr = array($arr);
                return $arr;
            } else {
                return $arr;
            }
            break;
        }
    }
    
    /**
     * validate data
     * set bDataEmpty (if data is empty)
     * set bDataError (if data error) 
     * 
     * set data and error array
     */
    function validate($arr0)
	{
	    $bError = false;
	    $bEmpty = true;
	    
	    // set aData array with string
	    foreach ($arr0['string'] as $value) {
	        $aData[$value] = isset($_POST[$value]) ? $_POST[$value] : '';
	        $nLen = strlen(trim($aData[$value]));
	        if ($nLen > 0 && $nLen < 2) {
	            $bEmpty = false;
	            $aError[$value] = true;
	            $bError = true;
	        } else if ($nLen > 0) {
	            $bEmpty = false;
	            $aError[$value] = false;
	        } else {
	            $aError[$value] = false;
	        }
	    }
	    
	    // set aData array with nums
	    foreach ($arr0['num'] as $value) {
	        $aData[$value] = isset($_POST[$value]) ? $_POST[$value] : '';
	        if (!is_numeric($aData[$value]) && trim($aData[$value]) <> '') {
	            $bEmpty = false;
	            $aError[$value] = true;
	            $bError = true;
	        } else if (trim($aData[$value]) <> ''){
	            $aError[$value] = false;
	            $bEmpty = false;
	        } else {
	            $aError[$value] = false;
	        }
	    }
	    
	    $aData['date_from'] = mktime(0,0,0,$aData['date_from_m'],$aData['date_from_d'],$aData['date_from_y']);
	    if ($aData['date_from'] <= 0) {
	        $aData['date_from'] = '';
	    }
	        
	    $aData['date_to'] = mktime(0,0,0,$aData['date_to_m'],$aData['date_to_d'],$aData['date_to_y']);
	    if ($aData['date_to'] <= 0) {
	        $aData['date_to'] = '';
	    }
	    /*
	    // set aData array with dates
	    foreach ($arr0['date'] as $value) {
	        $aData[$value] = isset($_POST[$value]) ? $_POST[$value] : '';
	        if (trim($aData[$value]) <> '') {
	            $bEmpty = false;
	            $aDates = explode('.',$aData[$value]);
	            $aData[$value] = @mktime(0,0,0,$aDates[1],$aDates[0],$aDates[2]);
	            $aError[$value] = false;
	        } else {
	            $aError[$value] = false;
	        } 
	    }
	    */
	    
	    // validate
	    $this->bDataError = $bError;
	    $this->bDataEmpty = $bEmpty;
	    
	    $this->aError = $aError;
	    $this->aData  = $aData;
	}
	
	
	/**
	 * set partner variables
	 * 
	 * @param nPid int partner id
	 * @param cUsername string partner username
	 * @param cPassword string partner password
	 * 
	 */
	function setPartner($nPid='', $cUsername='', $cPassword='')
	{
	    // SET PID
	    if ($nPid <> '') {
	        $this->nPid = $nPid;
	    } else if (defined('PID')) {
	        $this->nPid = PID;
	    } else {
	        $this->nPid = '';
	    }
	    
	    // SET USERNAME
	    if ($cUsername <> '') {
	        $this->cUsername = $cUsername;
	    } else if (defined('USERNAME')) {
	        $this->cUsername = USERNAME;
	    } else {
	        $this->cUsername = '';
	    }
	    
	    // SET PASSWORD
	    if ($cPassword <> '') {
	        $this->cPassword = $cPassword;
	    } else if (defined('PASSWORD')) {
	        $this->cPassword = PASSWORD;
	    } else {
	        $this->cPassword = '';
	    }
	}
}

/**
 *
 * Convert object to array
 *
 */
function object_to_array($obj)
{
    $_arr = is_object($obj) ? get_object_vars($obj) : $obj;
    foreach ($_arr as $key => $val) {
        $val = (is_array($val) || is_object($val)) ? object_to_array($val) : $val;
        $arr[$key] = $val;
    }
    
    return $arr;
}

?>
